/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit.server;

import cn.jmicro.api.JMicro;
import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.annotation.Reference;
import cn.jmicro.api.annotation.SMethod;
import cn.jmicro.api.annotation.Service;
import cn.jmicro.api.async.IPromise;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.idgenerator.ComponentIdServer;
import cn.jmicro.api.limit.genclient.ILimitData;
import cn.jmicro.api.monitor.IStatisDataSubscribe;
import cn.jmicro.api.monitor.StatisConfig;
import cn.jmicro.api.monitor.StatisData;
import cn.jmicro.api.monitor.StatisIndex;
import cn.jmicro.api.objectfactory.AbstractClientServiceProxyHolder;
import cn.jmicro.api.raft.IDataOperator;
import cn.jmicro.api.registry.ServiceItem;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.api.registry.UniqueServiceKey;
import cn.jmicro.api.registry.UniqueServiceMethodKey;
import cn.jmicro.api.service.ServiceManager;
import cn.jmicro.common.util.JsonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(version="0.0.1", external=false)
public class LimitServer
implements IStatisDataSubscribe {
    private static final Logger logger = LoggerFactory.getLogger(LimitServer.class);
    @Inject
    private ComponentIdServer idGenerator;
    @Reference(namespace="*", version="*", type="ins", required=false, changeListener="subscriberChange")
    private Set<ILimitData.JMAsyncClient> dataReceivers = new HashSet<ILimitData.JMAsyncClient>();
    private Map<String, ILimitData.JMAsyncClient> ins2Limiters = new HashMap<String, ILimitData.JMAsyncClient>();
    private Map<String, RegEntry> regs = new HashMap<String, RegEntry>();
    @Inject
    private ServiceManager srvManager;
    @Inject
    private IDataOperator op;
    private StatisIndex[] qpsStatisIndex = new StatisIndex[1];

    public static void main(String[] args) {
        JMicro.getObjectFactoryAndStart((String[])args);
        JMicro.waitForShutdown();
    }

    public void ready() {
        this.qpsStatisIndex[0] = new StatisIndex();
        this.qpsStatisIndex[0].setName("qps");
        this.qpsStatisIndex[0].setNums(new Short[]{(short)89});
        this.qpsStatisIndex[0].setDesc("service qps");
        this.qpsStatisIndex[0].setType((byte)3);
        this.srvManager.addListener((type, item) -> {
            if (type == 1) {
                this.serviceAdd(item);
            } else if (type == 2) {
                this.serviceRemove(item);
            } else if (type == 3) {
                this.serviceDataChange(item);
            }
        });
        logger.info("Limiter server ready!");
    }

    @SMethod(needResponse=false)
    public IPromise<Void> onData(StatisData sc) {
        int insSize;
        UniqueServiceMethodKey k = UniqueServiceMethodKey.fromKey((String)sc.getKey());
        Set sis = this.srvManager.getServiceItems(k.getServiceName(), k.getNamespace(), k.getVersion());
        sc.setIndex("insSize", (Object)sis.size());
        Double qps = (Double)sc.getStatis().get("qps");
        if (sc.containIndex("insSize") && (insSize = ((Integer)sc.getIndex("insSize")).intValue()) > 1) {
            Double avgQps = qps / (double)insSize;
            sc.setIndex("avgQps", (Object)avgQps);
        }
        logger.debug("OnData: " + JsonUtils.getIns().toJson((Object)sc));
        for (ServiceItem si : sis) {
            ILimitData.JMAsyncClient r = this.ins2Limiters.get(si.getKey().getInstanceName());
            if (r == null) continue;
            r.onDataJMAsync(sc).fail((code, msg, cxt) -> logger.error(sc.getKey() + " err: " + msg));
        }
        return null;
    }

    private void serviceDataChange(ServiceItem item) {
        for (ServiceMethod sm : item.getMethods()) {
            String key = sm.getKey().toKey(false, false, false);
            if (this.regs.containsKey(key)) {
                RegEntry re = this.regs.get(key);
                if (sm.getMaxSpeed() > 0) continue;
                if (re.smInsCount > 1) {
                    re.smInsCount--;
                    continue;
                }
                this.regs.remove(key);
                String path = StatisConfig.STATIS_CONFIG_ROOT + "/" + re.cid;
                this.op.deleteNode(path);
                continue;
            }
            if (sm.getMaxSpeed() <= 0) continue;
            this.createStatisConfig(sm);
        }
    }

    private void serviceRemove(ServiceItem item) {
        for (ServiceMethod sm : item.getMethods()) {
            String key = sm.getKey().toKey(false, false, false);
            if (!this.regs.containsKey(key)) continue;
            RegEntry re = this.regs.get(key);
            if (re.smInsCount > 1) {
                re.smInsCount--;
                continue;
            }
            this.regs.remove(key);
            String path = StatisConfig.STATIS_CONFIG_ROOT + "/" + re.cid;
            this.op.deleteNode(path);
        }
    }

    private void serviceAdd(ServiceItem item) {
        for (ServiceMethod sm : item.getMethods()) {
            if (sm.getMaxSpeed() <= 0) continue;
            this.createStatisConfig(sm);
        }
    }

    private void createStatisConfig(ServiceMethod sm) {
        if (sm.getLimitType() != 2) {
            return;
        }
        String key = sm.getKey().toKey(false, false, false);
        if (this.regs.containsKey(key)) {
            RegEntry re;
            RegEntry regEntry = re = this.regs.get(key);
            regEntry.smInsCount = regEntry.smInsCount + 1;
            re.sm = sm;
            return;
        }
        StatisConfig sc = new StatisConfig();
        sc.setId(this.idGenerator.getIntId(StatisConfig.class).intValue());
        sc.setByType(1);
        sc.setByKey(key);
        if (sm.getMaxSpeed() > 10) {
            sc.setExpStr("qps>" + sm.getMaxSpeed());
        } else {
            sc.setExpStr("qps>" + sm.getMaxSpeed());
        }
        if (sm.getMaxSpeed() > 10) {
            sc.setExpStr1("qps<" + sm.getMaxSpeed());
        } else {
            sc.setExpStr1("qps<" + sm.getMaxSpeed());
        }
        sc.setToType(2);
        StringBuilder sb = new StringBuilder();
        sb.append(UniqueServiceKey.serviceName((String)IStatisDataSubscribe.class.getName(), (String)"limitServer", (String)"*"));
        sb.append("########").append("onData").append("##");
        sc.setToParams(sb.toString());
        sc.setCounterTimeout(60);
        sc.setTimeUnit("S");
        sc.setTimeCnt(1);
        sc.setEnable(true);
        sc.setStatisIndexs(this.qpsStatisIndex);
        sc.setCreatedBy(Config.getClientId());
        String path = StatisConfig.STATIS_CONFIG_ROOT + "/" + sc.getId();
        this.op.createNodeOrSetData(path, JsonUtils.getIns().toJson((Object)sc), true);
        RegEntry re = new RegEntry();
        re.cid = sc.getId();
        re.smKey = key;
        re.sm = sm;
        re.smInsCount = 1;
        this.regs.put(key, re);
    }

    public void subscriberChange(AbstractClientServiceProxyHolder srv, int type) {
        ServiceItem si = srv.getItem();
        String insName = si.getKey().getInstanceName();
        if (type == 1) {
            ILimitData.JMAsyncClient djm = (ILimitData.JMAsyncClient)srv;
            if (!this.ins2Limiters.containsKey(insName)) {
                this.ins2Limiters.put(insName, djm);
            }
        } else if (type == 2 && this.ins2Limiters.containsKey(insName)) {
            this.ins2Limiters.remove(insName, srv);
        }
    }

    private class RegEntry {
        private int cid;
        private String smKey;
        private ServiceMethod sm;
        private int smInsCount;

        private RegEntry() {
        }
    }
}

