/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit;

import cn.jmicro.common.CommonException;
import cn.jmicro.common.util.StringUtils;
import cn.jmicro.limit.ITokenBucket;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenBucket
implements ITokenBucket {
    private int speed;
    private AtomicInteger currTokenNum = new AtomicInteger(0);
    private int maxToken = 0x7FFFFFFE;
    private Timer timer = new Timer();
    private Queue<Integer> applyQueue = new ConcurrentLinkedQueue<Integer>();
    private int maxQueueSize = 6;
    private String speedUnit = "ms";

    public TokenBucket(String su) {
        this.speedUnit = su;
    }

    public TokenBucket(String su, int speed) {
        this.speedUnit = su;
        this.updateSpeed(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int applyToken(int permits) {
        if (this.checkPermits(permits)) {
            this.get(permits);
            return 0;
        }
        if (this.applyQueue.size() > this.maxQueueSize) {
            return -1;
        }
        int waitTime = this.howLong(permits);
        Integer p = new Integer(permits);
        this.applyQueue.offer(p);
        Integer n = p;
        synchronized (n) {
            try {
                p.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return waitTime;
    }

    @Override
    public int howLong(int permits) {
        return permits / this.speed;
    }

    @Override
    public void updateSpeed(int s) {
        if (this.speed == s) {
            return;
        }
        this.maxToken = s * 5;
        this.speed = s;
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TokenBucket.this.doAdd();
            }
        }, 0L, (long)this.toMilliseconds(1));
    }

    private int toMilliseconds(int s) {
        if (StringUtils.isEmpty((String)this.speedUnit)) {
            return s;
        }
        switch (this.speedUnit.toLowerCase()) {
            case "ms": {
                return s;
            }
            case "ns": {
                return s / 1000;
            }
            case "s": {
                return s * 1000;
            }
            case "m": {
                return s * 1000 * 60;
            }
            case "h": {
                return s * 1000 * 60 * 60;
            }
        }
        throw new CommonException("Invalid speed unit: " + this.speedUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd() {
        Integer ap;
        if (this.currTokenNum.get() + this.speed <= this.maxToken) {
            this.currTokenNum.getAndAdd(this.speed);
        }
        while (!this.applyQueue.isEmpty() && this.checkPermits(ap = this.applyQueue.peek())) {
            this.get(ap);
            Integer n = ap;
            synchronized (n) {
                this.applyQueue.poll();
                ap.notify();
            }
        }
    }

    private boolean checkPermits(int permits) {
        if (permits <= 0) {
            throw new CommonException("Invalid permits :" + permits);
        }
        return this.currTokenNum.get() >= permits;
    }

    private void get(int permits) {
        this.currTokenNum.addAndGet(-permits);
    }
}

