/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit;

import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.limitspeed.ILimiter;
import cn.jmicro.api.net.IRequest;
import cn.jmicro.api.registry.ServiceItem;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.api.registry.UniqueServiceMethodKey;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class GuavaBaseLimiter
implements ILimiter {
    private Map<String, RateLimiter> rateLimiter = new ConcurrentHashMap<String, RateLimiter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enter(IRequest req) {
        int timeout;
        String key = this.key(req);
        ServiceMethod sm = (ServiceMethod)JMicroContext.get().getObject("serviceMethodKey", null);
        ServiceItem item = (ServiceItem)JMicroContext.get().getObject("serviceItemKey", null);
        RateLimiter rl = this.rateLimiter.get(key);
        if (rl == null) {
            String string = key = key.intern();
            synchronized (string) {
                rl = this.rateLimiter.get(key);
                if (rl == null) {
                    float maxSpeed = -1.0f;
                    if (sm != null) {
                        maxSpeed = sm.getMaxSpeed();
                    }
                    if (maxSpeed == -1.0f && item != null) {
                        maxSpeed = item.getMaxSpeed();
                    }
                    if (maxSpeed > 0.0f) {
                        rl = RateLimiter.create((double)sm.getMaxSpeed());
                        this.rateLimiter.put(key, rl);
                    } else {
                        return true;
                    }
                }
            }
        }
        if ((timeout = sm.getTimeout()) < 0) {
            timeout = item.getTimeout();
        }
        if (timeout > 0) {
            return rl.tryAcquire(1, (long)timeout, TimeUnit.MILLISECONDS);
        }
        rl.acquire(1);
        return true;
    }

    private String key(IRequest req) {
        String key = UniqueServiceMethodKey.paramsStr((Object[])req.getArgs());
        key = key + req.getMethod() + req.getImpl();
        return key;
    }

    public void end(IRequest req) {
    }
}

