/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.mng.mail;

import cn.jmicro.api.annotation.Cfg;
import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Service;
import cn.jmicro.api.email.IEmailSender;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(version="0.0.1", retryCnt=0, external=false, debugMode=1, showFront=false)
public class MailSender
implements IEmailSender {
    private static final Logger logger = LoggerFactory.getLogger(MailSender.class);
    @Cfg(value="/MailSender/from", defGlobal=true)
    private String mailFrom = "378862956@qq.com";
    private String passwordMailFrom = "";
    @Cfg(value="/MailSender/host", defGlobal=true)
    private String mailHost = "smtp.qq.com";
    @Cfg(value="/MailSender/code", defGlobal=true)
    private String code = "";

    public static void main(String[] args) throws Exception {
        new MailSender().send("xiaoruanfang@sina.com", "\u8282\u65e5\u5feb\u4e50", "\u6d4b\u8bd5\u53d1\u9001\u90ae\u4ef6");
    }

    public boolean send0(String to, String title, String content) {
        logger.info("code:" + this.code + ", mail from: " + this.mailFrom);
        Properties prop = new Properties();
        prop.setProperty("mail.host", this.mailHost);
        prop.setProperty("mail.port", "465");
        prop.setProperty("mail.transport.protocol", "smtp");
        prop.setProperty("mail.smtp.auth", "true");
        try {
            Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailSender.this.mailFrom, MailSender.this.code);
                }
            });
            session.setDebug(true);
            Transport ts = session.getTransport();
            ts.connect(this.mailHost, this.mailFrom, this.passwordMailFrom);
            MimeMessage message = this.createSimpleMail(session, this.mailFrom, to, title, content);
            ts.sendMessage((Message)message, message.getAllRecipients());
            ts.close();
        }
        catch (Exception e) {
            logger.error(to + " : " + title + " : " + content, (Throwable)e);
            return false;
        }
        return true;
    }

    private MimeMessage createSimpleMail(Session session, String mailfrom, String mailTo, String mailTittle, String mailText) throws Exception {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(mailfrom));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailTo));
        message.setSubject(mailTittle);
        message.setContent((Object)mailText, "text/html;charset=UTF-8");
        return message;
    }

    public boolean send(String to, String title, String message) {
        try {
            Security.addProvider((java.security.Provider)new Provider());
            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", this.mailHost);
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailSender.this.mailFrom, MailSender.this.code);
                }
            });
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.mailFrom));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setSubject(title);
            msg.setText(message);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

