/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.idgenerator;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.idgenerator.IIdServer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(value="defaultGenerator", level=1)
public class JMicroRedisBaseIdGenerator
implements IIdServer {
    private static final String ID_IDR = Config.getRaftBasePath((String)"") + "/id/";
    @Inject(required=true)
    private JedisPool pool;
    private String luaScript = null;

    public JMicroRedisBaseIdGenerator() {
        StringBuilder sb = new StringBuilder();
        sb.append("local k = KEYS[1];\n");
        sb.append("local cnt = ARGV[1];\n");
        sb.append("local val = tonumber(redis.call('incrby', k, cnt));\n");
        sb.append("return val;\n");
        this.luaScript = sb.toString();
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] getIntIds(String idKey, int num) {
        try (Jedis r = this.pool.getResource();){
            int endId = Integer.parseInt(r.eval(this.luaScript, 1, new String[]{idKey, num + ""}).toString());
            Integer[] ids = new Integer[num];
            int oriId = endId - num;
            for (int i = 0; i < num; ++i) {
                ids[i] = oriId + i + 1;
            }
            Integer[] integerArray = ids;
            return integerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getLongIds(String idKey, int num) {
        try (Jedis r = this.pool.getResource();){
            long endId = Long.parseLong(r.eval(this.luaScript, 1, new String[]{idKey, num + ""}).toString());
            Long[] ids = new Long[num];
            long oriId = endId - (long)num;
            for (int i = 0; i < num; ++i) {
                ids[i] = oriId + (long)i + 1L;
            }
            Long[] longArray = ids;
            return longArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringIds(String idKey, int num) {
        try (Jedis r = this.pool.getResource();){
            long endId = Long.parseLong(r.eval(this.luaScript, 1, new String[]{idKey, num + ""}).toString());
            String[] ids = new String[num];
            long oriId = endId - (long)num;
            for (int i = 0; i < num; ++i) {
                ids[i] = new Long(oriId + (long)i + 1L).toString();
            }
            String[] stringArray = ids;
            return stringArray;
        }
    }

    public Long getLongId(String idKey) {
        return this.getLongIds(idKey, 1)[0];
    }

    public String getStringId(String idKey) {
        return this.getStringIds(idKey, 1)[0];
    }

    public Integer getIntId(String idKey) {
        return this.getIntIds(idKey, 1)[0];
    }
}

