/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.codegenerator;

import java.lang.reflect.Method;

public class AsyncClientUtils {
    public static final String genSyncServiceName(String fullName) {
        String iname = fullName;
        if (fullName.endsWith("$Gateway$JMAsyncClient")) {
            String cn = fullName.substring(0, fullName.indexOf("$Gateway$JMAsyncClient"));
            String pkgName = cn.substring(0, cn.lastIndexOf("."));
            pkgName = pkgName.substring(0, pkgName.indexOf("genclient"));
            String simpleClassName = cn.substring(cn.lastIndexOf(".") + 1, cn.length());
            iname = pkgName + simpleClassName;
        } else if (fullName.endsWith("$JMAsyncClientImpl")) {
            String cn = fullName.substring(0, fullName.indexOf("$JMAsyncClientImpl"));
            String pkgName = cn.substring(0, cn.lastIndexOf("."));
            pkgName = pkgName.substring(0, pkgName.indexOf("genclient"));
            String simpleClassName = "I" + cn.substring(cn.lastIndexOf(".") + 1, cn.length());
            iname = pkgName + simpleClassName;
        } else if (fullName.endsWith("$JMAsyncClient")) {
            String cn = fullName.substring(0, fullName.indexOf("$JMAsyncClient"));
            String pkgName = cn.substring(0, cn.lastIndexOf("."));
            pkgName = pkgName.substring(0, pkgName.indexOf("genclient"));
            String simpleClassName = cn.substring(cn.lastIndexOf(".") + 1, cn.length());
            iname = pkgName + simpleClassName;
        }
        return iname;
    }

    public static final String genAsyncServiceName(String fullName) {
        if (fullName.endsWith("$Gateway$JMAsyncClient")) {
            return fullName.substring(0, fullName.length() - "$Gateway$JMAsyncClient".length()) + "$JMAsyncClient";
        }
        if (fullName.endsWith("$JMAsyncClient")) {
            return fullName;
        }
        if (fullName.endsWith("$JMAsyncClientImpl")) {
            String cn = fullName.substring(0, fullName.indexOf("$JMAsyncClientImpl"));
            String pkgName = cn.substring(0, cn.lastIndexOf("."));
            String clsName = cn.substring(cn.lastIndexOf(".") + 1, cn.length());
            String fn = pkgName + ".I" + clsName + "$JMAsyncClient";
            return fn;
        }
        String pkgName = "";
        int idx = fullName.lastIndexOf(".");
        pkgName = idx > 0 ? fullName.substring(0, idx) + "." + "genclient" : "genclient";
        String cln = fullName.substring(idx + 1) + "$JMAsyncClient";
        return pkgName + "." + cln;
    }

    public static final String genGatewayServiceName(String fullName) {
        if (fullName.endsWith("$Gateway$JMAsyncClient")) {
            return fullName;
        }
        if (fullName.endsWith("$JMAsyncClientImpl")) {
            String cn = fullName.substring(0, fullName.indexOf("$JMAsyncClientImpl"));
            String pkgName = cn.substring(0, cn.lastIndexOf("."));
            String clsName = cn.substring(cn.lastIndexOf(".") + 1, cn.length());
            String fn = pkgName + ".I" + clsName + "$Gateway$JMAsyncClient";
            return fn;
        }
        if (fullName.endsWith("$JMAsyncClient")) {
            return fullName.substring(0, fullName.length() - "$JMAsyncClient".length()) + "$Gateway$JMAsyncClient";
        }
        String pkgName = "";
        int idx = fullName.lastIndexOf(".");
        pkgName = idx > 0 ? fullName.substring(0, idx) + "." + "genclient" : "genclient";
        String cln = fullName.substring(idx + 1) + "$Gateway$JMAsyncClient";
        return pkgName + "." + cln;
    }

    public static final String genAsyncServiceImplName(String fullName) {
        if (fullName.endsWith("$JMAsyncClientImpl")) {
            return fullName;
        }
        if (fullName.endsWith("$Gateway$JMAsyncClient")) {
            fullName = AsyncClientUtils.genAsyncServiceName(fullName);
            return fullName + "$JMAsyncClient";
        }
        if (fullName.endsWith("$JMAsyncClient")) {
            int idx = fullName.lastIndexOf(".");
            String pkgName = fullName.substring(0, idx);
            String cn = fullName.substring(idx + 1);
            if (cn.startsWith("I")) {
                cn = cn.substring(1);
            }
            return pkgName + "." + cn + "Impl";
        }
        String pkgName = "";
        int idx = fullName.lastIndexOf(".");
        pkgName = idx > 0 ? fullName.substring(0, idx) + "." + "genclient" : "genclient";
        String cln = fullName.substring(idx + 1);
        cln = cln.startsWith("I") ? cln.substring(1) + "$JMAsyncClientImpl" : cln + "$JMAsyncClientImpl";
        return pkgName + "." + cln;
    }

    public static final String genAsyncMethodName(String methodName) {
        if (!methodName.endsWith("JMAsync")) {
            return methodName + "JMAsync";
        }
        return methodName;
    }

    public static final String genSyncMethodName(String methodName) {
        if (methodName.endsWith("JMAsync")) {
            return methodName.substring(0, methodName.length() - "JMAsync".length());
        }
        return methodName;
    }

    public static final Class<?> parseServiceClass(Class<?> type) {
        String cn = type.getSimpleName();
        if (cn.endsWith("$Gateway$JMAsyncClient")) {
            return type.getInterfaces()[0];
        }
        if (cn.endsWith("$JMAsyncClient")) {
            return type.getInterfaces()[0].getInterfaces()[0];
        }
        if (cn.endsWith("$JMAsyncClientImpl")) {
            return type.getInterfaces()[0].getInterfaces()[0].getInterfaces()[0];
        }
        return type;
    }

    public static final Method getMethod(Class<?> cls, String methodName) {
        Method[] ms = cls.getMethods();
        if (ms != null && ms.length > 0) {
            for (Method m : ms) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
        }
        return null;
    }

    public static final Method getMethod(Class<?> cls, String methodName, Class<?> paramClses) throws NoSuchMethodException, SecurityException {
        return cls.getMethod(methodName, paramClses);
    }
}

