/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.io.ply;

import cn.jimmiez.pcu.Constants;
import cn.jimmiez.pcu.io.BinaryWriter;
import cn.jimmiez.pcu.io.ply.PlyElement;
import cn.jimmiez.pcu.io.ply.PlyPropertyType;
import cn.jimmiez.pcu.io.ply.WriteListToPly;
import cn.jimmiez.pcu.io.ply.WriteScalarToPly;
import cn.jimmiez.pcu.util.PcuReflectUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlyWriter {
    public int write(Object object, File file) {
        int result = Constants.ERR_CODE_NO_ERROR;
        try {
            this.writeWithObject(object, file);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            result = Constants.ERR_CODE_METHOD_NO_LIST;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void writeWithObject(Object object, File file) throws InvocationTargetException, IllegalAccessException {
        List<Method> allMethods = PcuReflectUtil.fetchAllMethods(object);
        PlyWriterRequest request = new PlyWriterRequest();
        request.format(12289);
        request.comment("written by PointCloudUtil.");
        Map<String, List<Method>> getters = this.findPropertiesGetters(allMethods);
        for (String key : getters.keySet()) {
            request.defineElement(key);
            for (Method m : getters.get(key)) {
                List data;
                if (this.hasWriteScalarToPly(m)) {
                    WriteScalarToPly scalarToPly = m.getAnnotation(WriteScalarToPly.class);
                    if (scalarToPly.properties().length < 1) continue;
                    data = (List)m.invoke(object, new Object[0]);
                    String[] propertyNames = scalarToPly.properties();
                    PlyPropertyType type = scalarToPly.type();
                    request.defineScalarProperties(propertyNames, type, data);
                }
                if (!this.hasWriteListToPly(m)) continue;
                WriteListToPly listToPly = m.getAnnotation(WriteListToPly.class);
                data = (List)m.invoke(object, new Object[0]);
                PlyPropertyType sizeType = listToPly.sizeType();
                PlyPropertyType valType = listToPly.valType();
                request.defineListProperty(listToPly.property(), sizeType, valType, data);
            }
        }
        request.writeTo(file);
        request.okay();
    }

    private boolean hasWriteScalarToPly(Method m) {
        return m.getAnnotation(WriteScalarToPly.class) != null;
    }

    private boolean hasWriteListToPly(Method m) {
        return m.getAnnotation(WriteListToPly.class) != null;
    }

    private Map<String, List<Method>> findPropertiesGetters(List<Method> allMethods) {
        Annotation ply;
        HashMap<String, List<Method>> map = new HashMap<String, List<Method>>();
        for (Method m : allMethods) {
            if (!this.hasWriteScalarToPly(m)) continue;
            ply = m.getAnnotation(WriteScalarToPly.class);
            if (map.get(ply.element()) == null) {
                map.put(ply.element(), new ArrayList());
            }
            ((List)map.get(ply.element())).add(m);
        }
        for (Method m : allMethods) {
            if (!this.hasWriteListToPly(m)) continue;
            ply = m.getAnnotation(WriteListToPly.class);
            if (map.get(ply.element()) == null) {
                map.put(ply.element(), new ArrayList());
            }
            ((List)map.get(ply.element())).add(m);
        }
        return map;
    }

    private String typeString(PlyElement element, int position) {
        PlyPropertyType type = element.getPropertiesType().get(position);
        String typeStr = type.typeName();
        if (type == PlyPropertyType.LIST) {
            PlyPropertyType[] typePair = element.listTypes.get(element.getPropertiesName().get(position));
            typeStr = typeStr + String.format(" %s %s", typePair[0].typeName(), typePair[1].typeName());
        }
        return typeStr;
    }

    private void writeImpl(PlyWriterRequest request) throws IOException {
        StringBuffer buffer = this.generatePlyHeaderString(request);
        if (request.format == 12289) {
            this.writeAsciiPlyImpl(buffer, request);
        } else if (request.format == 12290) {
            this.writeBinaryPlyImpl(buffer, request, ByteOrder.BIG_ENDIAN);
        } else if (request.format == 12291) {
            this.writeBinaryPlyImpl(buffer, request, ByteOrder.LITTLE_ENDIAN);
        } else {
            System.err.println("Warning: unsupported ply format.");
        }
    }

    private StringBuffer generatePlyHeaderString(PlyWriterRequest request) {
        StringBuffer buffer = new StringBuffer("ply\n");
        buffer.append("format ");
        switch (request.format) {
            case 12289: {
                buffer.append("ascii");
                break;
            }
            case 12290: {
                buffer.append("binary_big_endian");
                break;
            }
            case 12291: {
                buffer.append("binary_little_endian");
            }
        }
        buffer.append(" 1.0\n");
        for (String comment : request.comments) {
            if (comment.contains("\n")) {
                System.err.println("Warning: Do not use LF(\\n) in your comment.");
                System.err.println("This comment will be neglected. " + comment);
                continue;
            }
            buffer.append("comment ").append(comment).append("\n");
        }
        for (PlyElement element : request.elements) {
            buffer.append("element ").append(element.elementName);
            int dataSize = 0;
            if (element.propertiesName.size() > 0) {
                dataSize = request.elementData.get(element.elementName).get(element.propertiesName.get(0)).size();
            }
            buffer.append(" ").append(dataSize).append("\n");
            for (int i = 0; i < element.propertiesName.size(); ++i) {
                buffer.append("property ").append(this.typeString(element, i)).append(" ").append(element.propertiesName.get(i)).append("\n");
            }
        }
        buffer.append("end_header\n");
        return buffer;
    }

    private void writeAsciiPlyImpl(StringBuffer header, PlyWriterRequest pq) throws FileNotFoundException {
        File file = pq.file;
        PrintStream ps = new PrintStream(new FileOutputStream(file));
        ps.print(header.toString());
        for (PlyElement element : pq.elements) {
            Map<String, List> dataMap = pq.elementData.get(element.elementName);
            if (element.propertiesName.size() < 1) continue;
            int dataSize = dataMap.get(element.propertiesName.get(0)).size();
            for (int i = 0; i < dataSize; ++i) {
                int cnt = 0;
                List partOfData = null;
                for (int j = 0; j < element.propertiesType.size(); ++j) {
                    PlyPropertyType type = element.propertiesType.get(j);
                    String propertyName = element.propertiesName.get(j);
                    if (partOfData == null || dataMap.get(propertyName) != partOfData) {
                        partOfData = dataMap.get(propertyName);
                        cnt = 0;
                    }
                    switch (type) {
                        case CHAR: 
                        case UCHAR: {
                            Object[] partOfRow = (byte[])partOfData.get(i);
                            ps.print(partOfRow[cnt++]);
                            break;
                        }
                        case SHORT: 
                        case USHORT: {
                            Object[] partOfRow = (short[])partOfData.get(i);
                            ps.print(partOfRow[cnt++]);
                            break;
                        }
                        case INT: 
                        case UINT: {
                            Object[] partOfRow = (int[])partOfData.get(i);
                            ps.print(partOfRow[cnt++]);
                            break;
                        }
                        case FLOAT: {
                            Object[] partOfRow = (float[])partOfData.get(i);
                            ps.print((float)partOfRow[cnt++]);
                            break;
                        }
                        case DOUBLE: {
                            Object[] partOfRow = (double[])partOfData.get(i);
                            ps.print((double)partOfRow[cnt++]);
                            break;
                        }
                        case LIST: {
                            this.printAsciiList(partOfData.get(i), ps, element.listTypes.get(propertyName)[1]);
                        }
                    }
                    ps.print(' ');
                }
                ps.print('\n');
            }
        }
        ps.close();
    }

    private void printAsciiList(Object o, PrintStream ps, PlyPropertyType valType) {
        switch (valType) {
            case CHAR: 
            case UCHAR: {
                byte[] ba = (byte[])o;
                ps.print(ba.length);
                ps.print(' ');
                for (byte b : ba) {
                    ps.print(b);
                    ps.print(' ');
                }
                break;
            }
            case SHORT: 
            case USHORT: {
                short[] sa = (short[])o;
                ps.print(sa.length);
                ps.print(' ');
                for (short s : sa) {
                    ps.print(s);
                    ps.print(' ');
                }
                break;
            }
            case INT: 
            case UINT: {
                int[] ia = (int[])o;
                ps.print(ia.length);
                ps.print(' ');
                for (int i : ia) {
                    ps.print(i);
                    ps.print(' ');
                }
                break;
            }
            case FLOAT: {
                float[] fa = (float[])o;
                ps.print(fa.length);
                ps.print(' ');
                for (float f : fa) {
                    ps.print(f);
                    ps.print(' ');
                }
                break;
            }
            case DOUBLE: {
                double[] da = (double[])o;
                ps.print(da.length);
                ps.print(' ');
                for (double d : da) {
                    ps.print(d);
                    ps.print(' ');
                }
                break;
            }
        }
    }

    private void writeBinaryPlyImpl(StringBuffer buffer, PlyWriterRequest pq, ByteOrder order) throws IOException {
        BinaryWriter writer = new BinaryWriter(pq.file, order);
        writer.writeString(buffer.toString());
        for (PlyElement element : pq.elements) {
            Map<String, List> dataMap = pq.elementData.get(element.elementName);
            if (element.propertiesName.size() < 1) continue;
            int dataSize = dataMap.get(element.propertiesName.get(0)).size();
            for (int i = 0; i < dataSize; ++i) {
                int cnt = 0;
                List partOfData = null;
                block10: for (int j = 0; j < element.propertiesType.size(); ++j) {
                    PlyPropertyType type = element.propertiesType.get(j);
                    String propertyName = element.propertiesName.get(j);
                    if (partOfData == null || dataMap.get(propertyName) != partOfData) {
                        partOfData = dataMap.get(propertyName);
                        cnt = 0;
                    }
                    switch (type) {
                        case CHAR: 
                        case UCHAR: {
                            Object[] partOfRow = (byte[])partOfData.get(i);
                            writer.writeByte(partOfRow[cnt++]);
                            continue block10;
                        }
                        case SHORT: 
                        case USHORT: {
                            Object[] partOfRow = (short[])partOfData.get(i);
                            writer.writeShort(partOfRow[cnt++]);
                            continue block10;
                        }
                        case INT: 
                        case UINT: {
                            Object[] partOfRow = (int[])partOfData.get(i);
                            writer.writeInt(partOfRow[cnt++]);
                            continue block10;
                        }
                        case FLOAT: {
                            Object[] partOfRow = (float[])partOfData.get(i);
                            writer.writeFloat(partOfRow[cnt++]);
                            continue block10;
                        }
                        case DOUBLE: {
                            Object[] partOfRow = (double[])partOfData.get(i);
                            writer.writeDouble(partOfRow[cnt++]);
                            continue block10;
                        }
                        case LIST: {
                            PlyPropertyType sizeType = element.listTypes.get(propertyName)[0];
                            PlyPropertyType valType = element.listTypes.get(propertyName)[1];
                            this.writeBinaryList(partOfData.get(i), writer, valType, sizeType);
                            continue block10;
                        }
                    }
                }
            }
        }
        writer.close();
    }

    private void writeListSize(int len, BinaryWriter writer, PlyPropertyType sizeType) throws IOException {
        switch (sizeType) {
            case CHAR: 
            case UCHAR: {
                writer.writeByte((byte)len);
                break;
            }
            case SHORT: 
            case USHORT: {
                writer.writeShort((short)len);
                break;
            }
            case INT: 
            case UINT: {
                writer.writeInt(len);
                break;
            }
            case FLOAT: {
                writer.writeFloat(len);
                break;
            }
            case DOUBLE: {
                writer.writeDouble(len);
            }
        }
    }

    private void writeBinaryList(Object o, BinaryWriter writer, PlyPropertyType valType, PlyPropertyType sizeType) throws IOException {
        switch (valType) {
            case CHAR: 
            case UCHAR: {
                byte[] ba = (byte[])o;
                this.writeListSize(ba.length, writer, sizeType);
                for (byte b : ba) {
                    writer.writeByte(b);
                }
                break;
            }
            case SHORT: 
            case USHORT: {
                short[] sa = (short[])o;
                this.writeListSize(sa.length, writer, sizeType);
                for (short s : sa) {
                    writer.writeShort(s);
                }
                break;
            }
            case INT: 
            case UINT: {
                int[] ia = (int[])o;
                this.writeListSize(ia.length, writer, sizeType);
                for (int i : ia) {
                    writer.writeInt(i);
                }
                break;
            }
            case FLOAT: {
                float[] fa = (float[])o;
                this.writeListSize(fa.length, writer, sizeType);
                for (float f : fa) {
                    writer.writeFloat(f);
                }
                break;
            }
            case DOUBLE: {
                double[] da = (double[])o;
                this.writeListSize(da.length, writer, sizeType);
                for (double d : da) {
                    writer.writeDouble(d);
                }
                break;
            }
        }
    }

    public PlyWriterRequest prepare() {
        return new PlyWriterRequest();
    }

    public class PlyWriterRequest {
        List<PlyElement> elements = new ArrayList<PlyElement>();
        Map<String, Map<String, List>> elementData = new HashMap<String, Map<String, List>>();
        int format = 12289;
        List<String> comments = new ArrayList<String>();
        File file = null;

        private PlyWriterRequest() {
        }

        public PlyWriterRequest defineElement(String elementName) {
            PlyElement element = new PlyElement();
            element.elementName = elementName;
            this.elements.add(element);
            this.elementData.put(elementName, new HashMap());
            return this;
        }

        public PlyWriterRequest defineScalarProperties(String[] propertyNames, PlyPropertyType valType, List data) {
            if (this.elements.size() < 1) {
                throw new IllegalStateException("defineElement() must be called before defineScalarProperties()");
            }
            PlyElement element = this.elements.get(this.elements.size() - 1);
            for (String propertyName : propertyNames) {
                element.propertiesName.add(propertyName);
                element.propertiesType.add(valType);
                this.elementData.get(element.elementName).put(propertyName, data);
            }
            return this;
        }

        public PlyWriterRequest defineListProperty(String propertyName, PlyPropertyType sizeType, PlyPropertyType valType, List data) {
            if (this.elements.size() < 1) {
                throw new IllegalStateException("defineElement() must be called before defineScalarProperties()");
            }
            PlyElement element = this.elements.get(this.elements.size() - 1);
            element.propertiesName.add(propertyName);
            element.propertiesType.add(PlyPropertyType.LIST);
            element.listTypes.put(propertyName, new PlyPropertyType[]{sizeType, valType});
            this.elementData.get(element.elementName).put(propertyName, data);
            return this;
        }

        public PlyWriterRequest format(int format) {
            this.format = format;
            return this;
        }

        public PlyWriterRequest comment(String comment) {
            this.comments.add(comment);
            return this;
        }

        public PlyWriterRequest writeTo(File file) {
            this.file = file;
            return this;
        }

        public int okay() {
            if (this.file == null) {
                throw new IllegalStateException("writeTo() must be called before okay()");
            }
            int result = Constants.ERR_CODE_NO_ERROR;
            try {
                this.checkData();
                PlyWriter.this.writeImpl(this);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                result = Constants.ERR_CODE_FILE_NOT_FOUND;
            }
            catch (IOException e) {
                e.printStackTrace();
                result = Constants.ERR_CODE_FILE_NOT_FOUND;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                result = Constants.ERR_CODE_BAD_WRITE_REQUEST;
            }
            return result;
        }

        private void checkData() {
            for (Map<String, List> m : this.elementData.values()) {
                if (m.size() < 1) continue;
                int dataSize = 0;
                for (List l : m.values()) {
                    if (dataSize == 0) {
                        dataSize = l.size();
                    }
                    if (l.size() == dataSize) continue;
                    throw new IllegalStateException("Data lists for one PlyElement should have same size.");
                }
            }
        }
    }
}

