/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.io.ply;

import cn.jimmiez.pcu.Constants;
import cn.jimmiez.pcu.io.ReadListener;
import cn.jimmiez.pcu.io.ply.PlyElement;
import cn.jimmiez.pcu.io.ply.PlyHeader;
import cn.jimmiez.pcu.io.ply.PlyPropertyType;
import cn.jimmiez.pcu.io.ply.ReadFromPly;
import cn.jimmiez.pcu.util.Pair;
import cn.jimmiez.pcu.util.PcuReflectUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Vector;

public class PlyReader {
    public static final int FORMAT_ASCII = 12289;
    public static final int FORMAT_BINARY_BIG_ENDIAN = 12290;
    public static final int FORMAT_BINARY_LITTLE_ENDIAN = 12291;
    public static final int FORMAT_NON_FORMAT = -12289;
    private int ERR_LINE_NO = 0;

    public PlyHeader readHeaderThenCloseFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        PlyHeader result = this.readHeader(reader);
        reader.close();
        return result;
    }

    public PlyHeader readHeader(FileReader reader) throws IOException {
        Scanner scanner = new Scanner(reader);
        return this.readHeader(scanner);
    }

    private PlyHeader readHeader(Scanner scanner) throws IOException {
        PlyHeader header = new PlyHeader();
        ArrayList<String> headerLines = new ArrayList<String>();
        int byteCount = 0;
        try {
            String line;
            while ((line = scanner.nextLine()) != null) {
                byteCount += line.getBytes().length + 1;
                if (!line.equals("end_header")) {
                    if (line.startsWith("comment ")) continue;
                    headerLines.add(line);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException e) {
            throw new IOException("Invalid ply file: Cannot find end of header.");
        }
        if (headerLines.size() < 1) {
            throw new IOException("Invalid ply file: No data");
        }
        header.setHeaderBytes(byteCount);
        this.ERR_LINE_NO = headerLines.size() + 1;
        String firstLine = (String)headerLines.get(0);
        if (!firstLine.equals("ply")) {
            throw new IOException("Invalid ply file: Ply file does not start with ply.");
        }
        String secondLine = (String)headerLines.get(1);
        this.readPlyFormat(secondLine, header);
        int lineNo = 2;
        while (lineNo < headerLines.size()) {
            String elementLine = (String)headerLines.get(lineNo);
            Pair<String, Integer> pair = this.readPlyElement(elementLine);
            int propertyStartNo = ++lineNo;
            while (lineNo < headerLines.size() && ((String)headerLines.get(lineNo)).startsWith("property ")) {
                ++lineNo;
            }
            PlyElement element = new PlyElement();
            for (int i = propertyStartNo; i < lineNo; ++i) {
                String[] propertySlices = ((String)headerLines.get(i)).split(" ");
                if (propertySlices.length < 3) {
                    throw new IOException("Invalid ply file.");
                }
                element.propertiesName.add(propertySlices[propertySlices.length - 1]);
                element.propertiesType.add(PlyReader.recognizeType(propertySlices[1]));
                if (element.propertiesType.get(i - propertyStartNo) != PlyPropertyType.LIST) continue;
                if (propertySlices.length < 5) {
                    throw new IOException("Invalid ply file. Wrong list property.");
                }
                PlyPropertyType[] types = new PlyPropertyType[]{PlyReader.recognizeType(propertySlices[2]), PlyReader.recognizeType(propertySlices[3])};
                element.getListTypes().put(element.propertiesName.get(i - propertyStartNo), types);
            }
            header.getElementTypes().put(pair.getKey(), element);
            header.getElementsNumber().add(pair);
        }
        return header;
    }

    public static PlyPropertyType recognizeType(String type) {
        switch (type) {
            case "char": 
            case "int8": {
                return PlyPropertyType.CHAR;
            }
            case "uchar": 
            case "uint8": {
                return PlyPropertyType.UCHAR;
            }
            case "int": 
            case "int32": {
                return PlyPropertyType.INT;
            }
            case "uint": 
            case "uint32": {
                return PlyPropertyType.UINT;
            }
            case "short": 
            case "int16": {
                return PlyPropertyType.SHORT;
            }
            case "ushort": 
            case "uint16": {
                return PlyPropertyType.USHORT;
            }
            case "float": 
            case "float32": {
                return PlyPropertyType.FLOAT;
            }
            case "double": 
            case "float64": {
                return PlyPropertyType.DOUBLE;
            }
            case "list": {
                return PlyPropertyType.LIST;
            }
        }
        return PlyPropertyType.NON_TYPE;
    }

    private Pair<String, Integer> readPlyElement(String line) throws IOException {
        String[] elementSlices = line.split(" ");
        if (!line.startsWith("element ") || elementSlices.length < 3) {
            throw new IOException("Invalid ply file: Invalid format.");
        }
        String elementName = elementSlices[1];
        Integer elementNumber = Integer.valueOf(elementSlices[2]);
        return new Pair<String, Integer>(elementName, elementNumber);
    }

    private void readPlyFormat(String line, PlyHeader header) throws IOException {
        if (!line.startsWith("format ")) {
            throw new IOException("Invalid ply file: No format information");
        }
        String[] formatSlices = line.split(" ");
        if (formatSlices.length == 3) {
            switch (formatSlices[1]) {
                case "ascii": {
                    header.setPlyFormat(12289);
                    break;
                }
                case "binary_little_endian": {
                    header.setPlyFormat(12291);
                    break;
                }
                case "binary_big_endian": {
                    header.setPlyFormat(12290);
                }
            }
        } else {
            throw new IOException("Invalid ply file: Wrong format ply in line");
        }
        header.setPlyVersion(Float.valueOf(formatSlices[2]).floatValue());
    }

    public <T> T read(File file, Class<T> clazz) {
        T object = null;
        final ArrayList errorCodes = new ArrayList();
        try {
            object = clazz.newInstance();
            this.read(file, object, new ReadListener(){

                @Override
                public void onFail(int code, String message) {
                    errorCodes.add(code);
                    System.err.println("Read point cloud failed, error code: " + code);
                    System.err.println(message);
                }
            });
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (errorCodes.size() > 0) {
            return null;
        }
        return object;
    }

    private List<Method> findAllElementGetter(List<Method> methods) {
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method m : methods) {
            ReadFromPly pcuEle = m.getAnnotation(ReadFromPly.class);
            if (pcuEle == null) continue;
            getters.add(m);
        }
        return getters;
    }

    private <T> DataContainer generateParserCallback(final T userDefinedObject, final PlyHeader header) {
        List<Method> allMethods = PcuReflectUtil.fetchAllMethods(userDefinedObject);
        final List<Method> getters = this.findAllElementGetter(allMethods);
        return new DataContainer(header){

            @Override
            void release() throws InvocationTargetException, IllegalAccessException {
                block7: for (Method method : getters) {
                    boolean isListType;
                    String[] properties;
                    ReadFromPly annotation = method.getAnnotation(ReadFromPly.class);
                    String elementName = annotation.element();
                    int elementNumber = 0;
                    if (header.getElementTypes().get(elementName) == null) {
                        throw new IllegalStateException("Cannot find the element in ply for your getter: " + method.getName());
                    }
                    for (Pair<String, Integer> pair : header.getElementsNumber()) {
                        if (!pair.getKey().equals(elementName)) continue;
                        elementNumber = pair.getValue();
                        break;
                    }
                    if ((properties = annotation.properties()).length < 1) {
                        return;
                    }
                    PlyElement plyElement = header.getElementTypes().get(elementName);
                    int propertyPosition = plyElement.propertiesName.indexOf(properties[0]);
                    if (propertyPosition == -1) {
                        throw new IllegalStateException("The property " + properties[0] + " for getter: " + method.getName() + " cannot be found in ply header!");
                    }
                    PlyPropertyType firstPropertyType = plyElement.propertiesType.get(propertyPosition);
                    int[] indices = new int[properties.length];
                    int period = 0;
                    for (int j = 0; j < indices.length; ++j) {
                        String propertyName = properties[j];
                        int[] startIndexAndPeriod = (int[])this.positionRecord.get(new Pair<String, String>(elementName, propertyName));
                        indices[j] = startIndexAndPeriod[0];
                        period = startIndexAndPeriod[1];
                    }
                    boolean bl = isListType = firstPropertyType == PlyPropertyType.LIST;
                    if (isListType) {
                        if (properties.length > 1) {
                            throw new IllegalStateException("You need declare the name of only one list-type property.");
                        }
                        firstPropertyType = plyElement.listTypes.get(properties[0])[1];
                    }
                    switch (firstPropertyType) {
                        case FLOAT: {
                            int k;
                            Object[] vector;
                            List list = (List)method.invoke(userDefinedObject, new Object[0]);
                            if (isListType) {
                                for (int j = 0; j < elementNumber; ++j) {
                                    list.add(this.floatListData.get(indices[0] + j * period));
                                }
                                continue block7;
                            }
                            for (int j = 0; j < elementNumber; ++j) {
                                vector = new float[properties.length];
                                for (k = 0; k < properties.length; ++k) {
                                    vector[k] = this.floatData[indices[k] + j * period];
                                }
                                list.add(vector);
                            }
                            continue block7;
                        }
                        case DOUBLE: {
                            int k;
                            Object[] vector;
                            List list = (List)method.invoke(userDefinedObject, new Object[0]);
                            if (isListType) {
                                for (int j = 0; j < elementNumber; ++j) {
                                    list.add(this.doubleListData.get(indices[0] + j * period));
                                }
                                continue block7;
                            }
                            for (int j = 0; j < elementNumber; ++j) {
                                vector = new double[properties.length];
                                for (k = 0; k < properties.length; ++k) {
                                    vector[k] = (float)this.doubleData[indices[k] + j * period];
                                }
                                list.add(vector);
                            }
                            continue block7;
                        }
                        case INT: 
                        case UINT: {
                            int k;
                            Object[] vector;
                            List list = (List)method.invoke(userDefinedObject, new Object[0]);
                            if (isListType) {
                                for (int j = 0; j < elementNumber; ++j) {
                                    list.add(this.intListData.get(indices[0] + j * period));
                                }
                                continue block7;
                            }
                            for (int j = 0; j < elementNumber; ++j) {
                                vector = new int[properties.length];
                                for (k = 0; k < properties.length; ++k) {
                                    vector[k] = this.intData[indices[k] + j * period];
                                }
                                list.add(vector);
                            }
                            continue block7;
                        }
                        case SHORT: 
                        case USHORT: {
                            int k;
                            Object[] vector;
                            List list = (List)method.invoke(userDefinedObject, new Object[0]);
                            if (isListType) {
                                for (int j = 0; j < elementNumber; ++j) {
                                    list.add(this.shortListData.get(indices[0] + j * period));
                                }
                                continue block7;
                            }
                            for (int j = 0; j < elementNumber; ++j) {
                                vector = new short[properties.length];
                                for (k = 0; k < properties.length; ++k) {
                                    vector[k] = this.shortData[indices[k] + j * period];
                                }
                                list.add(vector);
                            }
                            continue block7;
                        }
                        case CHAR: 
                        case UCHAR: {
                            int k;
                            Object[] vector;
                            List list = (List)method.invoke(userDefinedObject, new Object[0]);
                            if (isListType) {
                                for (int j = 0; j < elementNumber; ++j) {
                                    list.add(this.byteListData.get(indices[0] + j * period));
                                }
                                continue block7;
                            }
                            for (int j = 0; j < elementNumber; ++j) {
                                vector = new byte[properties.length];
                                for (k = 0; k < properties.length; ++k) {
                                    vector[k] = this.byteData[indices[k] + j * period];
                                }
                                list.add(vector);
                            }
                            continue block7;
                        }
                    }
                }
            }
        };
    }

    public <T> void read(File file, T pointCloud, ReadListener listener) {
        if (!file.exists()) {
            listener.onFail(Constants.ERR_CODE_FILE_NOT_FOUND, "File does NOT exist.");
            return;
        }
        PlyHeader header = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            Scanner scanner = new Scanner(stream);
            header = this.readHeader(scanner);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_FILE_HEADER_FORMAT_ERROR, e.getMessage());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_NOT_3D_PLY, e.getMessage());
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_NOT_ENOUGH_POINTS, e.getMessage());
        }
        if (header == null) {
            return;
        }
        try {
            DataContainer container = this.generateParserCallback(pointCloud, header);
            PlyBodyParser parser = new PlyBodyParser(header, container);
            switch (header.getPlyFormat()) {
                case 12289: {
                    parser.readAsciiData(file);
                    container.release();
                    break;
                }
                case 12290: {
                    parser.readBinaryData(file, ByteOrder.BIG_ENDIAN);
                    container.release();
                    break;
                }
                case 12291: {
                    parser.readBinaryData(file, ByteOrder.LITTLE_ENDIAN);
                    container.release();
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_PRIVATE_METHOD, e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_METHOD_NO_LIST, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.onFail(Constants.ERR_CODE_FILE_DATA_FORMAT_ERROR, e.getMessage());
        }
    }

    private class PlyBodyParser {
        private ParserCallback callback;
        private PlyHeader header;
        private static final int STATE_READY = 0;
        private static final int STATE_READING_SCALAR_VAL = 1;
        private static final int STATE_READING_LIST_SIZE = 2;
        private static final int STATE_READING_LIST_VAL = 3;
        private static final int STATE_TO_READ_NEXT_PROPERTY = 6;
        private static final int STATE_ERROR = 4;
        private static final int STATE_COMPLETE = 5;

        public PlyBodyParser(PlyHeader header, ParserCallback callback) {
            this.header = header;
            this.callback = callback;
        }

        public void readBinaryData(File file, ByteOrder order) throws IOException {
            int state = 0;
            PlyPropertyType expectedType = PlyPropertyType.NON_TYPE;
            String currentElementName = null;
            int currentElementPtr = 0;
            int currentPropertyPtr = 0;
            int currentItemNumber = 0;
            int currentListSize = 0;
            byte[] bytes = Files.readAllBytes(file.toPath());
            int currBytePtr = this.header.getHeaderBytes();
            boolean loop = true;
            while (loop) {
                block0 : switch (state) {
                    case 0: {
                        currentElementPtr = 0;
                        currentPropertyPtr = 0;
                        currentItemNumber = 0;
                        state = 6;
                        break;
                    }
                    case 6: {
                        if (currentElementPtr >= this.header.getElementsNumber().size()) {
                            state = 5;
                            break;
                        }
                        if (currentItemNumber >= this.header.getElementsNumber().get(currentElementPtr).getValue()) {
                            currentItemNumber = 0;
                            ++currentElementPtr;
                            break;
                        }
                        currentElementName = this.header.getElementsNumber().get(currentElementPtr).getKey();
                        if (currentPropertyPtr >= this.header.getElementTypes().get((Object)currentElementName).propertiesType.size()) {
                            currentPropertyPtr = 0;
                            ++currentItemNumber;
                            break;
                        }
                        expectedType = this.header.getElementTypes().get((Object)currentElementName).propertiesType.get(currentPropertyPtr);
                        if (expectedType != PlyPropertyType.LIST) {
                            state = 1;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        state = 6;
                        ByteBuffer buffer = ByteBuffer.wrap(bytes, currBytePtr, expectedType.size());
                        buffer.order(order);
                        currBytePtr += expectedType.size();
                        switch (expectedType) {
                            case DOUBLE: {
                                this.callback.gotDoubleVal(currentElementName, currentPropertyPtr, buffer.getDouble());
                                break;
                            }
                            case FLOAT: {
                                this.callback.gotFloatVal(currentElementName, currentPropertyPtr, buffer.getFloat());
                                break;
                            }
                            case INT: 
                            case UINT: {
                                this.callback.gotIntVal(currentElementName, currentPropertyPtr, buffer.getInt());
                                break;
                            }
                            case SHORT: 
                            case USHORT: {
                                this.callback.gotShortVal(currentElementName, currentPropertyPtr, buffer.getShort());
                                break;
                            }
                            case CHAR: 
                            case UCHAR: {
                                this.callback.gotByte(currentElementName, currentPropertyPtr, buffer.get());
                                break;
                            }
                            case LIST: {
                                state = 4;
                            }
                        }
                        ++currentPropertyPtr;
                        break;
                    }
                    case 2: {
                        state = 3;
                        PlyElement element = this.header.getElementTypes().get(currentElementName);
                        String currentProperty = element.propertiesName.get(currentPropertyPtr);
                        PlyPropertyType[] listTypes = element.listTypes.get(currentProperty);
                        if (listTypes == null || listTypes.length < 2) {
                            System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE. listSize too short.");
                            state = 4;
                            break;
                        }
                        PlyPropertyType firstType = listTypes[0];
                        ByteBuffer buffer = ByteBuffer.wrap(bytes, currBytePtr, firstType.size());
                        currBytePtr += firstType.size();
                        buffer.order(order);
                        switch (firstType) {
                            case FLOAT: 
                            case DOUBLE: 
                            case LIST: {
                                System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE.");
                                state = 4;
                                break block0;
                            }
                            case INT: 
                            case UINT: {
                                currentListSize = buffer.getInt();
                                break block0;
                            }
                            case SHORT: 
                            case USHORT: {
                                currentListSize = buffer.getShort();
                                break block0;
                            }
                            case CHAR: 
                            case UCHAR: {
                                currentListSize = buffer.get();
                            }
                        }
                        break;
                    }
                    case 3: {
                        state = 6;
                        PlyElement element = this.header.getElementTypes().get(currentElementName);
                        String currentProperty = element.propertiesName.get(currentPropertyPtr);
                        PlyPropertyType[] listTypes = element.listTypes.get(currentProperty);
                        if (listTypes == null || listTypes.length < 2) {
                            System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE. listSize too short.");
                            state = 4;
                            break;
                        }
                        PlyPropertyType listItemType = listTypes[1];
                        ByteBuffer buffer = ByteBuffer.wrap(bytes, currBytePtr, listItemType.size() * currentListSize);
                        currBytePtr += listItemType.size() * currentListSize;
                        buffer.order(order);
                        switch (listItemType) {
                            case DOUBLE: {
                                double[] doubleList = new double[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    doubleList[i] = buffer.getDouble();
                                }
                                this.callback.gotDoubleArray(currentElementName, doubleList);
                            }
                            case FLOAT: {
                                float[] floatList = new float[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    floatList[i] = buffer.getFloat();
                                }
                                this.callback.gotFloatArray(currentElementName, floatList);
                            }
                            case INT: 
                            case UINT: {
                                int[] intList = new int[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    intList[i] = buffer.getInt();
                                }
                                this.callback.gotIntArray(currentElementName, intList);
                                break;
                            }
                            case SHORT: 
                            case USHORT: {
                                short[] shortList = new short[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    shortList[i] = buffer.getShort();
                                }
                                this.callback.gotShortArray(currentElementName, shortList);
                                break;
                            }
                            case CHAR: 
                            case UCHAR: {
                                byte[] byteList = new byte[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    byteList[i] = buffer.get();
                                }
                                this.callback.gotByteArray(currentElementName, byteList);
                                break;
                            }
                            case LIST: {
                                System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE.");
                                state = 4;
                            }
                        }
                        ++currentPropertyPtr;
                        break;
                    }
                    case 5: {
                        loop = false;
                        break;
                    }
                    case 4: {
                        loop = false;
                        System.err.println("Parse ply file failed, element: " + currentElementName + ", property: " + this.header.getElementTypes().get(currentElementName).propertiesName.get(currentPropertyPtr));
                        System.err.println("Parse stop at item: " + currentItemNumber);
                    }
                }
            }
        }

        public void readAsciiData(File file) throws NoSuchElementException, IOException {
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes, this.header.getHeaderBytes(), bytes.length - this.header.getHeaderBytes());
            Scanner scanner = new Scanner(stream);
            int state = 0;
            PlyPropertyType expectedType = PlyPropertyType.NON_TYPE;
            String currentElementName = null;
            int currentElementPtr = 0;
            int currentPropertyPtr = 0;
            int currentItemNumber = 0;
            int currentListSize = 0;
            boolean loop = true;
            while (loop) {
                block0 : switch (state) {
                    case 0: {
                        currentElementPtr = 0;
                        currentPropertyPtr = 0;
                        currentItemNumber = 0;
                        state = 6;
                        break;
                    }
                    case 6: {
                        if (currentElementPtr >= this.header.getElementsNumber().size()) {
                            state = 5;
                            break;
                        }
                        if (currentItemNumber >= this.header.getElementsNumber().get(currentElementPtr).getValue()) {
                            currentItemNumber = 0;
                            ++currentElementPtr;
                            break;
                        }
                        currentElementName = this.header.getElementsNumber().get(currentElementPtr).getKey();
                        if (currentPropertyPtr >= this.header.getElementTypes().get((Object)currentElementName).propertiesType.size()) {
                            currentPropertyPtr = 0;
                            ++currentItemNumber;
                            break;
                        }
                        expectedType = this.header.getElementTypes().get((Object)currentElementName).propertiesType.get(currentPropertyPtr);
                        if (expectedType != PlyPropertyType.LIST) {
                            state = 1;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        state = 6;
                        switch (expectedType) {
                            case DOUBLE: {
                                this.callback.gotDoubleVal(currentElementName, currentPropertyPtr, scanner.nextDouble());
                                break;
                            }
                            case FLOAT: {
                                this.callback.gotFloatVal(currentElementName, currentPropertyPtr, scanner.nextFloat());
                                break;
                            }
                            case INT: 
                            case UINT: {
                                this.callback.gotIntVal(currentElementName, currentPropertyPtr, scanner.nextInt());
                                break;
                            }
                            case SHORT: 
                            case USHORT: {
                                this.callback.gotShortVal(currentElementName, currentPropertyPtr, scanner.nextShort());
                                break;
                            }
                            case CHAR: 
                            case UCHAR: {
                                this.callback.gotByte(currentElementName, currentPropertyPtr, scanner.nextByte());
                                break;
                            }
                            case LIST: {
                                state = 4;
                            }
                        }
                        ++currentPropertyPtr;
                        break;
                    }
                    case 2: {
                        state = 3;
                        PlyElement element = this.header.getElementTypes().get(currentElementName);
                        String currentProperty = element.propertiesName.get(currentPropertyPtr);
                        PlyPropertyType[] listTypes = element.listTypes.get(currentProperty);
                        if (listTypes == null || listTypes.length < 2) {
                            System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE. listSize too short.");
                            state = 4;
                            break;
                        }
                        PlyPropertyType firstType = listTypes[0];
                        switch (firstType) {
                            case FLOAT: 
                            case DOUBLE: 
                            case LIST: {
                                System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE.");
                                state = 4;
                                break block0;
                            }
                            case INT: 
                            case UINT: {
                                currentListSize = scanner.nextInt();
                                break block0;
                            }
                            case SHORT: 
                            case USHORT: {
                                currentListSize = scanner.nextShort();
                                break block0;
                            }
                            case CHAR: 
                            case UCHAR: {
                                currentListSize = scanner.nextByte();
                            }
                        }
                        break;
                    }
                    case 3: {
                        state = 6;
                        PlyElement element = this.header.getElementTypes().get(currentElementName);
                        String currentProperty = element.propertiesName.get(currentPropertyPtr);
                        PlyPropertyType[] listTypes = element.listTypes.get(currentProperty);
                        if (listTypes == null || listTypes.length < 2) {
                            System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE. listSize too short.");
                            state = 4;
                            break;
                        }
                        PlyPropertyType listItemType = listTypes[1];
                        switch (listItemType) {
                            case DOUBLE: {
                                double[] doubleList = new double[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    doubleList[i] = scanner.nextDouble();
                                }
                                this.callback.gotDoubleArray(currentElementName, doubleList);
                            }
                            case FLOAT: {
                                float[] floatList = new float[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    floatList[i] = scanner.nextFloat();
                                }
                                this.callback.gotFloatArray(currentElementName, floatList);
                            }
                            case INT: 
                            case UINT: {
                                int[] intList = new int[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    intList[i] = scanner.nextInt();
                                }
                                this.callback.gotIntArray(currentElementName, intList);
                                break;
                            }
                            case SHORT: 
                            case USHORT: {
                                short[] shortList = new short[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    shortList[i] = scanner.nextShort();
                                }
                                this.callback.gotShortArray(currentElementName, shortList);
                                break;
                            }
                            case CHAR: 
                            case UCHAR: {
                                byte[] byteList = new byte[currentListSize];
                                for (int i = 0; i < currentListSize; ++i) {
                                    byteList[i] = scanner.nextByte();
                                }
                                this.callback.gotByteArray(currentElementName, byteList);
                                break;
                            }
                            case LIST: {
                                System.err.println("PlyReader::readAsciiData(), STATE: READING_LIST_SIZE.");
                                state = 4;
                            }
                        }
                        ++currentPropertyPtr;
                        break;
                    }
                    case 5: {
                        loop = false;
                        break;
                    }
                    case 4: {
                        loop = false;
                    }
                }
            }
        }
    }

    private abstract class DataContainer
    implements ParserCallback {
        private PlyHeader header;
        protected Map<Pair<String, String>, int[]> positionRecord = new HashMap<Pair<String, String>, int[]>();
        protected double[] doubleData;
        protected float[] floatData;
        protected int[] intData;
        protected short[] shortData;
        protected byte[] byteData;
        protected List<double[]> doubleListData = null;
        protected List<float[]> floatListData = null;
        protected List<int[]> intListData = null;
        protected List<short[]> shortListData = null;
        protected List<byte[]> byteListData = null;
        private int doublePtr = 0;
        private int floatPtr = 0;
        private int intPtr = 0;
        private int shortPtr = 0;
        private int bytePtr = 0;

        public DataContainer(PlyHeader header) {
            this.header = header;
            this.initArray();
        }

        private void initArray() {
            int doubleDataLength = 0;
            int floatDataLength = 0;
            int intDataLength = 0;
            int shortDataLength = 0;
            int byteDataLength = 0;
            int doubleListDataLength = 0;
            int floatListDataLength = 0;
            int intListDataLength = 0;
            int shortListDataLength = 0;
            int byteListDataLength = 0;
            for (int i = 0; i < this.header.getElementsNumber().size(); ++i) {
                PlyPropertyType type;
                boolean isList;
                int j;
                String plyElementName = this.header.getElementsNumber().get(i).getKey();
                PlyElement element = this.header.getElementTypes().get(plyElementName);
                int doubleCnt = 0;
                int floatCnt = 0;
                int intCnt = 0;
                int shortCnt = 0;
                int byteCnt = 0;
                int doublePeriod = 0;
                int floatPeriod = 0;
                int intPeriod = 0;
                int shortPeriod = 0;
                int bytePeriod = 0;
                block15: for (j = 0; j < element.propertiesName.size(); ++j) {
                    isList = element.propertiesType.get(j) == PlyPropertyType.LIST;
                    type = isList ? element.listTypes.get(element.propertiesName.get(j))[1] : element.propertiesType.get(j);
                    switch (type) {
                        case FLOAT: {
                            ++floatPeriod;
                            continue block15;
                        }
                        case DOUBLE: {
                            ++doublePeriod;
                            continue block15;
                        }
                        case INT: 
                        case UINT: {
                            ++intPeriod;
                            continue block15;
                        }
                        case SHORT: 
                        case USHORT: {
                            ++shortPeriod;
                            continue block15;
                        }
                        case CHAR: 
                        case UCHAR: {
                            ++bytePeriod;
                        }
                    }
                }
                block16: for (j = 0; j < element.propertiesName.size(); ++j) {
                    isList = element.propertiesType.get(j) == PlyPropertyType.LIST;
                    type = isList ? element.listTypes.get(element.propertiesName.get(j))[1] : element.propertiesType.get(j);
                    String propertyName = element.propertiesName.get(j);
                    Pair<String, String> eleProNamePair = new Pair<String, String>(plyElementName, propertyName);
                    switch (type) {
                        case FLOAT: {
                            this.positionRecord.put(eleProNamePair, new int[]{floatDataLength + floatCnt, floatPeriod});
                            ++floatCnt;
                            continue block16;
                        }
                        case DOUBLE: {
                            this.positionRecord.put(eleProNamePair, new int[]{doubleDataLength + doubleCnt, doublePeriod});
                            ++doubleCnt;
                            continue block16;
                        }
                        case INT: 
                        case UINT: {
                            this.positionRecord.put(eleProNamePair, new int[]{intDataLength + intCnt, intPeriod});
                            ++intCnt;
                            continue block16;
                        }
                        case SHORT: 
                        case USHORT: {
                            this.positionRecord.put(eleProNamePair, new int[]{shortDataLength + shortCnt, shortPeriod});
                            ++shortCnt;
                            continue block16;
                        }
                        case CHAR: 
                        case UCHAR: {
                            this.positionRecord.put(eleProNamePair, new int[]{byteDataLength + byteCnt, bytePeriod});
                            ++byteCnt;
                        }
                    }
                }
                doubleDataLength += doublePeriod * this.header.getElementsNumber().get(i).getValue();
                floatDataLength += floatPeriod * this.header.getElementsNumber().get(i).getValue();
                intDataLength += intPeriod * this.header.getElementsNumber().get(i).getValue();
                shortDataLength += shortPeriod * this.header.getElementsNumber().get(i).getValue();
                byteDataLength += bytePeriod * this.header.getElementsNumber().get(i).getValue();
                doubleListDataLength += doubleCnt * this.header.getElementsNumber().get(i).getValue();
                floatListDataLength += floatCnt * this.header.getElementsNumber().get(i).getValue();
                intListDataLength += intCnt * this.header.getElementsNumber().get(i).getValue();
                shortListDataLength += shortCnt * this.header.getElementsNumber().get(i).getValue();
                byteListDataLength += byteCnt * this.header.getElementsNumber().get(i).getValue();
            }
            this.doubleData = new double[doubleDataLength];
            this.floatData = new float[floatDataLength];
            this.intData = new int[intDataLength];
            this.shortData = new short[shortDataLength];
            this.byteData = new byte[byteDataLength];
            this.doubleListData = new Vector<double[]>(doubleListDataLength);
            this.floatListData = new Vector<float[]>(floatListDataLength);
            this.intListData = new Vector<int[]>(intListDataLength);
            this.shortListData = new Vector<short[]>(shortListDataLength);
            this.byteListData = new Vector<byte[]>(byteListDataLength);
        }

        abstract void release() throws IllegalStateException, InvocationTargetException, IllegalAccessException;

        @Override
        public void gotDoubleVal(String elementName, int pos, double val) {
            this.doubleData[this.doublePtr++] = val;
        }

        @Override
        public void gotFloatVal(String elementName, int pos, float val) {
            this.floatData[this.floatPtr++] = val;
        }

        @Override
        public void gotIntVal(String elementName, int pos, int val) {
            this.intData[this.intPtr++] = val;
        }

        @Override
        public void gotShortVal(String elementName, int pos, short val) {
            this.shortData[this.shortPtr++] = val;
        }

        @Override
        public void gotByte(String elementName, int pos, byte val) {
            this.byteData[this.bytePtr++] = val;
        }

        @Override
        public void gotDoubleArray(String elementName, double[] array) {
            this.doubleListData.add(array);
        }

        @Override
        public void gotFloatArray(String elementName, float[] array) {
            this.floatListData.add(array);
        }

        @Override
        public void gotIntArray(String elementName, int[] array) {
            this.intListData.add(array);
        }

        @Override
        public void gotShortArray(String elementName, short[] array) {
            this.shortListData.add(array);
        }

        @Override
        public void gotByteArray(String elementName, byte[] array) {
            this.byteListData.add(array);
        }
    }

    private static interface ParserCallback {
        public void gotDoubleVal(String var1, int var2, double var3);

        public void gotFloatVal(String var1, int var2, float var3);

        public void gotIntVal(String var1, int var2, int var3);

        public void gotShortVal(String var1, int var2, short var3);

        public void gotByte(String var1, int var2, byte var3);

        public void gotDoubleArray(String var1, double[] var2);

        public void gotFloatArray(String var1, float[] var2);

        public void gotIntArray(String var1, int[] var2);

        public void gotShortArray(String var1, short[] var2);

        public void gotByteArray(String var1, byte[] var2);
    }
}

