/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.io.off;

import cn.jimmiez.pcu.io.off.OffData;
import cn.jimmiez.pcu.io.off.OffHeader;
import cn.jimmiez.pcu.io.off.ReadFromOff;
import cn.jimmiez.pcu.util.PcuReflectUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Scanner;

public class OffReader {
    private static final int STATE_READY = 0;
    private static final int STATE_PARSE_HEADER_KEYWORD = 1;
    private static final int STATE_PARSE_HEADER_N_DIM = 2;
    private static final int STATE_PARSE_ELEMENT_NUM = 3;
    private static final int STATE_READING_VERTICES = 4;
    private static final int STATE_READING_FACES = 5;
    private static final int STATE_COMPLETE = 6;
    private static final int STATE_ERROR = 7;

    private String fetchNextLine(Scanner scanner) {
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.startsWith("#")) continue;
            return line;
        }
        return null;
    }

    private void readImpl(Scanner scanner, OffData data) {
        int state = 0;
        boolean loop = true;
        OffHeader header = new OffHeader();
        while (loop) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 1: {
                    String line = this.fetchNextLine(scanner);
                    if (line == null) {
                        System.err.println("Cannot read first line.");
                        state = 7;
                        break;
                    }
                    String keyword = line.trim();
                    if (keyword.endsWith("OFF")) {
                        header.setName(keyword);
                        if (keyword.contains("ST")) {
                            header.setHasTextureCoordinates(true);
                        }
                        if (keyword.contains("N")) {
                            header.setHasNormal(true);
                        }
                        if (keyword.contains("C")) {
                            header.setHasColor(true);
                        }
                        if (keyword.contains("4")) {
                            header.setHas4Components(true);
                        }
                        if (keyword.contains("n")) {
                            header.setIfDimensionSpecified(true);
                        }
                    }
                    if (header.isDimensionSpecified()) {
                        state = 2;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 2: {
                    String line = this.fetchNextLine(scanner);
                    if (line == null) {
                        System.err.println("Cannot read number of dimensions.");
                        state = 7;
                        break;
                    }
                    int dimen = Integer.valueOf(line);
                    if (dimen >= 1) {
                        header.setDimension(dimen);
                        state = 3;
                        break;
                    }
                    System.err.println("Incorrect vertex dimension.");
                    state = 7;
                    break;
                }
                case 3: {
                    String line = this.fetchNextLine(scanner);
                    if (line == null) {
                        System.err.println("Cannot read number of vertices and faces.");
                        state = 7;
                        break;
                    }
                    String[] nums = line.split(" ");
                    int verticesNum = -1;
                    int facesNum = -1;
                    int edgesNum = -1;
                    if (nums.length < 2) {
                        System.err.println("Too few numbers for parsing element size.");
                        state = 7;
                        break;
                    }
                    verticesNum = Integer.valueOf(nums[0]);
                    facesNum = Integer.valueOf(nums[1]);
                    if (nums.length > 2) {
                        edgesNum = Integer.valueOf(nums[2]);
                    }
                    if (verticesNum >= 0) {
                        header.setVerticesNum(verticesNum);
                    }
                    if (facesNum >= 0) {
                        header.setFacesNum(facesNum);
                    }
                    if (edgesNum >= 0) {
                        header.setEdgesNum(edgesNum);
                    }
                    data.setHeader(header);
                    state = 4;
                    break;
                }
                case 4: {
                    float[] rgba;
                    int j;
                    if (header.getVerticesNum() == -1) {
                        System.err.println("Invalid number of vertices.");
                        state = 7;
                        break;
                    }
                    boolean success = true;
                    for (int i = 0; i < header.getVerticesNum(); ++i) {
                        String line = this.fetchNextLine(scanner);
                        if (line == null) {
                            System.err.println("Fewer vertices than expected.");
                            success = false;
                            break;
                        }
                        int expectedLength = 3;
                        String[] values = line.trim().split("(\\s)+");
                        float[] xyz = new float[3];
                        for (j = 0; j < 3; ++j) {
                            xyz[j] = Float.valueOf(values[j]).floatValue();
                        }
                        data.vertices.add(xyz);
                        if (header.hasTextureCoordinates()) {
                            System.out.println("Texture coordinates are currently unsupported.");
                            break;
                        }
                        if (header.hasNormal()) {
                            if (values.length >= (expectedLength += 3)) {
                                float[] normal = new float[3];
                                while (j < expectedLength) {
                                    normal[j - 3] = Float.valueOf(values[j]).floatValue();
                                    ++j;
                                }
                                data.vertexNormals.add(normal);
                            } else {
                                System.err.println("Fewer float values than expected.");
                                break;
                            }
                        }
                        if (!header.hasColor() || values.length < (expectedLength += 4)) continue;
                        rgba = new float[4];
                        while (j < expectedLength) {
                            rgba[j - (expectedLength - 4)] = Float.valueOf(values[j]).floatValue();
                            ++j;
                        }
                        data.vertexColors.add(rgba);
                    }
                    if (success) {
                        state = 5;
                        break;
                    }
                    state = 7;
                    break;
                }
                case 5: {
                    float[] rgba;
                    int j;
                    if (header.getFacesNum() == -1) {
                        System.err.println("Invalid number of faces.");
                        state = 7;
                        break;
                    }
                    boolean success = true;
                    for (int i = 0; i < header.getFacesNum(); ++i) {
                        String line = this.fetchNextLine(scanner);
                        if (line == null) {
                            System.err.println("Fewer faces than expected.");
                            success = false;
                            break;
                        }
                        String[] values = line.trim().split("(\\s)+");
                        int arrayLength = Integer.valueOf(values[0]);
                        int[] indices = new int[arrayLength];
                        for (j = 1; j < arrayLength + 1; ++j) {
                            indices[j - 1] = Integer.valueOf(values[j]);
                        }
                        data.faces.add(indices);
                        if (values.length < arrayLength + 5) continue;
                        rgba = new float[4];
                        while (j < arrayLength + 5) {
                            rgba[j - arrayLength - 1] = Float.valueOf(values[j]).floatValue();
                            ++j;
                        }
                        data.faceColors.add(rgba);
                    }
                    if (success) {
                        state = 6;
                        break;
                    }
                    state = 7;
                    break;
                }
                case 6: {
                    loop = false;
                    break;
                }
                case 7: {
                    loop = false;
                }
            }
        }
    }

    public OffData read(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        OffData data = new OffData();
        this.readImpl(scanner, data);
        return data;
    }

    private void injectData(OffData data, Object object) {
        List<Method> methods = PcuReflectUtil.fetchAllMethods(object);
        try {
            for (Method method : methods) {
                ReadFromOff annotation = method.getAnnotation(ReadFromOff.class);
                if (annotation == null) continue;
                if (annotation.dataType() == 0) {
                    this.injectVerticesData(method, data, object);
                    continue;
                }
                if (annotation.dataType() == 1) {
                    this.injectFacesData(method, data, object);
                    continue;
                }
                if (annotation.dataType() == 2) {
                    this.injectVertexColorsData(method, data, object);
                    continue;
                }
                if (annotation.dataType() != 3) continue;
                this.injectFaceColorsData(method, data, object);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("Privater getter with ReadFromOff annotation.");
            e.printStackTrace();
        }
    }

    private void injectVerticesData(Method method, OffData data, Object object) throws InvocationTargetException, IllegalAccessException {
        List list = (List)method.invoke(object, new Object[0]);
        list.addAll(data.vertices);
    }

    private void injectFacesData(Method method, OffData data, Object object) throws InvocationTargetException, IllegalAccessException {
        List list = (List)method.invoke(object, new Object[0]);
        list.addAll(data.faces);
    }

    private void injectVertexColorsData(Method method, OffData data, Object object) throws InvocationTargetException, IllegalAccessException {
        List list = (List)method.invoke(object, new Object[0]);
        list.addAll(data.vertexColors);
    }

    private void injectFaceColorsData(Method method, OffData data, Object object) throws InvocationTargetException, IllegalAccessException {
        List list = (List)method.invoke(object, new Object[0]);
        list.addAll(data.faceColors);
    }

    public <T> T read(File file, Class<T> clazz) throws FileNotFoundException {
        OffData data = this.read(file);
        T object = null;
        try {
            object = clazz.newInstance();
            this.injectData(data, object);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return object;
    }
}

