/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.io.obj;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ObjReader {
    private <T> void extractData(ObjParser parser, T object) {
    }

    public Map<ObjDataType, List<float[]>> read(File file) {
        if (!file.exists()) {
            System.err.println("File: " + file.getName() + " does NOT exist.");
            return null;
        }
        ObjParser parser = new ObjParser();
        try {
            parser.parseObjFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return parser.objData;
    }

    private static class ObjParser {
        private Map<ObjDataType, List<float[]>> objData = new HashMap<ObjDataType, List<float[]>>();
        private static final int STATE_READY = 0;
        private static final int STATE_READING_LINE = 1;
        private static final int STATE_PARSING_TYPE = 2;
        private static final int STATE_PARSING_DATA = 3;
        private static final int STATE_COMPLETE = 9;
        private static final int STATE_ERROR = 10;
        private static final Map<String, ObjDataType> KEYWORD_MAP = new HashMap<String, ObjDataType>();

        private ObjParser() {
        }

        public void parseObjFile(File file) throws IOException {
            this.objData.clear();
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Scanner scanner = new Scanner(stream);
            boolean loop = true;
            int currentState = 0;
            ObjDataType currentType = null;
            String currentLine = null;
            while (loop) {
                switch (currentState) {
                    case 0: {
                        currentLine = null;
                        currentType = null;
                        currentState = 1;
                        break;
                    }
                    case 1: {
                        if (scanner.hasNextLine()) {
                            currentLine = scanner.nextLine();
                            currentState = 2;
                            break;
                        }
                        currentState = 9;
                        break;
                    }
                    case 2: {
                        if (currentLine == null) {
                            currentState = 10;
                            break;
                        }
                        String[] slices = currentLine.split(" ");
                        if (slices.length < 1) {
                            currentState = 10;
                            break;
                        }
                        String typeKeyword = slices[0];
                        currentType = KEYWORD_MAP.get(typeKeyword);
                        if (currentType == null) {
                            System.err.println("Warning: unrecognized data type: " + typeKeyword);
                            currentState = 1;
                            break;
                        }
                        if (currentType.equals((Object)ObjDataType.COMMENT_COMMENT)) {
                            currentState = 1;
                            break;
                        }
                        if (this.objData.get((Object)currentType) == null) {
                            this.objData.put(currentType, new ArrayList());
                        }
                        currentState = 3;
                        break;
                    }
                    case 3: {
                        String[] slices = currentLine.split(" ");
                        float[] dataArray = new float[slices.length - 1];
                        for (int i = 1; i < slices.length; ++i) {
                            dataArray[i - 1] = Float.valueOf(slices[i]).floatValue();
                        }
                        this.objData.get((Object)currentType).add(dataArray);
                        currentState = 1;
                        break;
                    }
                    case 9: {
                        loop = false;
                        break;
                    }
                    case 10: {
                        loop = false;
                    }
                }
            }
        }

        static {
            KEYWORD_MAP.put("v", ObjDataType.V_GEOMETRIC_VERTICES);
            KEYWORD_MAP.put("vt", ObjDataType.VT_TEXTURE_VERTICES);
            KEYWORD_MAP.put("vn", ObjDataType.VN_VERTEX_NORMALS);
            KEYWORD_MAP.put("vp", ObjDataType.VP_PARAMETER_SPACE_VERTICES);
            KEYWORD_MAP.put("cstype", ObjDataType.CSTYPE_RATIONAL_FORMS_OF_CURVE_ETC);
            KEYWORD_MAP.put("deg", ObjDataType.DEG_DEGREE);
            KEYWORD_MAP.put("bmat", ObjDataType.BMAT_BASIS_MATRIX);
            KEYWORD_MAP.put("step", ObjDataType.STEP_STEP_SIZE);
            KEYWORD_MAP.put("p", ObjDataType.P_POINT);
            KEYWORD_MAP.put("l", ObjDataType.L_LINE);
            KEYWORD_MAP.put("f", ObjDataType.F_FACE);
            KEYWORD_MAP.put("curv", ObjDataType.CURV_CURVE);
            KEYWORD_MAP.put("curv2", ObjDataType.CURV2_2D_CURVE);
            KEYWORD_MAP.put("surf", ObjDataType.SURF_SURFACE);
            KEYWORD_MAP.put("parm", ObjDataType.PARM_PARAMETER_VALUES);
            KEYWORD_MAP.put("trim", ObjDataType.TRIM_OUTER_TRIMMING_LOOP);
            KEYWORD_MAP.put("hole", ObjDataType.HOLE_INNER_TRIMMING_LOOP);
            KEYWORD_MAP.put("scrv", ObjDataType.SCRV_SEPECIAL_CURVE);
            KEYWORD_MAP.put("sp", ObjDataType.SP_SPECIAL_POINT);
            KEYWORD_MAP.put("end", ObjDataType.END_END_STATEMENT);
            KEYWORD_MAP.put("con", ObjDataType.CON_CONNECT);
            KEYWORD_MAP.put("g", ObjDataType.G_GROUP_NAME);
            KEYWORD_MAP.put("s", ObjDataType.S_SMOOTHING_GROOP);
            KEYWORD_MAP.put("mg", ObjDataType.MG_MERGING_GROUP);
            KEYWORD_MAP.put("o", ObjDataType.O_OBJECT_NAME);
            KEYWORD_MAP.put("bevel", ObjDataType.BEVEL_BEVEL_INTERPOLATION);
            KEYWORD_MAP.put("c_interp", ObjDataType.C_INTERP_COLOR_INTERPOLATION);
            KEYWORD_MAP.put("d_interp", ObjDataType.D_INTERP_DISSOLVE_INTERPOLATION);
            KEYWORD_MAP.put("lod", ObjDataType.LOD_LEVEL_OF_DETAIL);
            KEYWORD_MAP.put("usemtl", ObjDataType.USEMTL_MATERIAL_NAME);
            KEYWORD_MAP.put("mtllib", ObjDataType.MTLLIB_MATERIAL_LIBRARY);
            KEYWORD_MAP.put("shadow_obj", ObjDataType.SHADOW_OBJ_SHADOW_CASTING);
            KEYWORD_MAP.put("trace_obj", ObjDataType.TRACE_OBJ_RAY_TRACING);
            KEYWORD_MAP.put("ctech", ObjDataType.CTECH_CURVE_APPROXIMATION_TECHNIQUE);
            KEYWORD_MAP.put("stech", ObjDataType.STECH_SURFACE_APPROXIMATION_TECHNIQUE);
            KEYWORD_MAP.put("#", ObjDataType.COMMENT_COMMENT);
        }
    }

    public static enum ObjDataType {
        V_GEOMETRIC_VERTICES,
        VT_TEXTURE_VERTICES,
        VN_VERTEX_NORMALS,
        VP_PARAMETER_SPACE_VERTICES,
        CSTYPE_RATIONAL_FORMS_OF_CURVE_ETC,
        DEG_DEGREE,
        BMAT_BASIS_MATRIX,
        STEP_STEP_SIZE,
        P_POINT,
        L_LINE,
        F_FACE,
        CURV_CURVE,
        CURV2_2D_CURVE,
        SURF_SURFACE,
        PARM_PARAMETER_VALUES,
        TRIM_OUTER_TRIMMING_LOOP,
        HOLE_INNER_TRIMMING_LOOP,
        SCRV_SEPECIAL_CURVE,
        SP_SPECIAL_POINT,
        END_END_STATEMENT,
        CON_CONNECT,
        G_GROUP_NAME,
        S_SMOOTHING_GROOP,
        MG_MERGING_GROUP,
        O_OBJECT_NAME,
        BEVEL_BEVEL_INTERPOLATION,
        C_INTERP_COLOR_INTERPOLATION,
        D_INTERP_DISSOLVE_INTERPOLATION,
        LOD_LEVEL_OF_DETAIL,
        USEMTL_MATERIAL_NAME,
        MTLLIB_MATERIAL_LIBRARY,
        SHADOW_OBJ_SHADOW_CASTING,
        TRACE_OBJ_RAY_TRACING,
        CTECH_CURVE_APPROXIMATION_TECHNIQUE,
        STECH_SURFACE_APPROXIMATION_TECHNIQUE,
        COMMENT_COMMENT;

    }
}

