/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;

public class BinaryWriter {
    private FileOutputStream fos = null;
    private ByteOrder order = null;
    private byte[] byteBuffer = new byte[1];
    private byte[] intBuffer = new byte[4];
    private byte[] shortBuffer = new byte[2];
    private byte[] longBuffer = new byte[8];

    public BinaryWriter(File file, ByteOrder order) throws FileNotFoundException {
        this.fos = new FileOutputStream(file);
        this.order = order;
    }

    public void writeString(String str) throws IOException {
        this.fos.write(str.getBytes());
    }

    public void writeInt(int i) throws IOException {
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            this.intBuffer[3] = (byte)(i >> 24 & 0xFF);
            this.intBuffer[2] = (byte)(i >> 16 & 0xFF);
            this.intBuffer[1] = (byte)(i >> 8 & 0xFF);
            this.intBuffer[0] = (byte)(i >> 0 & 0xFF);
        } else {
            this.intBuffer[0] = (byte)(i >> 24 & 0xFF);
            this.intBuffer[1] = (byte)(i >> 16 & 0xFF);
            this.intBuffer[2] = (byte)(i >> 8 & 0xFF);
            this.intBuffer[3] = (byte)(i >> 0 & 0xFF);
        }
        this.fos.write(this.intBuffer);
    }

    public void writeLong(long l) throws IOException {
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            this.longBuffer[7] = (byte)(l >> 56 & 0xFFL);
            this.longBuffer[6] = (byte)(l >> 48 & 0xFFL);
            this.longBuffer[5] = (byte)(l >> 40 & 0xFFL);
            this.longBuffer[4] = (byte)(l >> 32 & 0xFFL);
            this.longBuffer[3] = (byte)(l >> 24 & 0xFFL);
            this.longBuffer[2] = (byte)(l >> 16 & 0xFFL);
            this.longBuffer[1] = (byte)(l >> 8 & 0xFFL);
            this.longBuffer[0] = (byte)(l >> 0 & 0xFFL);
        } else {
            this.longBuffer[0] = (byte)(l >> 56 & 0xFFL);
            this.longBuffer[1] = (byte)(l >> 48 & 0xFFL);
            this.longBuffer[2] = (byte)(l >> 40 & 0xFFL);
            this.longBuffer[3] = (byte)(l >> 32 & 0xFFL);
            this.longBuffer[4] = (byte)(l >> 24 & 0xFFL);
            this.longBuffer[5] = (byte)(l >> 16 & 0xFFL);
            this.longBuffer[6] = (byte)(l >> 8 & 0xFFL);
            this.longBuffer[7] = (byte)(l >> 0 & 0xFFL);
        }
        this.fos.write(this.longBuffer);
    }

    public void writeByte(byte b) throws IOException {
        this.byteBuffer[0] = b;
        this.fos.write(this.byteBuffer);
    }

    public void writeShort(short s) throws IOException {
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            this.shortBuffer[1] = (byte)(s >> 8 & 0xFF);
            this.shortBuffer[0] = (byte)(s >> 0 & 0xFF);
        } else {
            this.shortBuffer[0] = (byte)(s >> 8 & 0xFF);
            this.shortBuffer[1] = (byte)(s >> 0 & 0xFF);
        }
        this.fos.write(this.shortBuffer);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void close() throws IOException {
        this.fos.close();
    }
}

