/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graphics;

import cn.jimmiez.pcu.common.graphics.BoundingBox;
import cn.jimmiez.pcu.common.graphics.Collisions;
import cn.jimmiez.pcu.common.graphics.shape.Box;
import cn.jimmiez.pcu.common.graphics.shape.Sphere;
import cn.jimmiez.pcu.util.PcuCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.vecmath.Point3d;

public class Octree {
    protected OctreeNode root = null;
    protected List<Point3d> points = null;
    protected Map<Long, OctreeNode> octreeIndices = new HashMap<Long, OctreeNode>();
    private static final int MAX_DEPTH = 10;
    private int maxPointsPerNode = 100;

    public void buildIndex(List<Point3d> points) {
        if (points.size() < 1) {
            System.err.println("Warning: input for buildIndex() is an empty list.");
            return;
        }
        this.octreeIndices.clear();
        this.points = points;
        this.createRootNode();
        this.createOctree(0, this.root);
    }

    public int[] searchNearestNeighbors(int k, int index) {
        if (this.points == null) {
            throw new IllegalStateException("Octree.buildIndex() must be called before searchNearestNeighbors.");
        }
        if (k >= this.points.size()) {
            throw new IllegalArgumentException("number of nearest neighbors is larger than data size");
        }
        return this.searchNearestNeighbors(k, this.points.get(index));
    }

    private Comparator<Integer> distanceComparator(final Point3d point) {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer pointIndex1, Integer pointIndex2) {
                Point3d p1 = Octree.this.points.get(pointIndex1);
                Point3d p2 = Octree.this.points.get(pointIndex2);
                return Double.compare(p1.distance(point), p2.distance(point));
            }
        };
    }

    public int[] searchNearestNeighbors(int k, Point3d point) {
        double leafSize;
        if (this.points == null) {
            throw new IllegalStateException("Octree.buildIndex() must be called before searchNearestNeighbors.");
        }
        if (k >= this.points.size()) {
            throw new IllegalArgumentException("number of nearest neighbors is larger than data size");
        }
        Comparator<Integer> comparator = this.distanceComparator(point);
        long leafNodeIndex = this.locateOctreeNode(this.root, point);
        ArrayList<Integer> queue = new ArrayList<Integer>();
        HashSet<Long> visited = new HashSet<Long>();
        OctreeNode leafNode = this.octreeIndices.get(leafNodeIndex);
        double currentSearchRadius = leafSize = leafNode.getxExtent();
        while (queue.size() < k) {
            HashSet<Long> candidates = new HashSet<Long>();
            this.determineCandidatesWithinRadius(currentSearchRadius, point, candidates);
            for (Long newNode : candidates) {
                if (visited.contains(newNode)) continue;
                visited.add(newNode);
                queue.addAll(this.octreeIndices.get((Object)newNode).indices);
            }
            Collections.sort(queue, comparator);
            while (queue.size() > k) {
                queue.remove(queue.size() - 1);
            }
            currentSearchRadius += leafSize;
        }
        int[] indices = new int[k];
        for (int i = 0; i < k; ++i) {
            indices[i] = (Integer)queue.get(i);
        }
        return indices;
    }

    private void createRootNode() {
        BoundingBox bbox = BoundingBox.of(this.points);
        double maxExtent = PcuCommonUtil.max(bbox.getxExtent(), bbox.getyExtent(), bbox.getzExtent());
        this.root = new OctreeNode(bbox.getCenter(), maxExtent, 0);
        this.root.indices = new ArrayList<Integer>(this.points.size());
        this.root.indices.addAll(PcuCommonUtil.incrementalIntegerList(this.points.size()));
    }

    private void createOctree(int currentDepth, OctreeNode currentNode) {
        if (currentNode.indices.size() < 1) {
            return;
        }
        if (currentNode.indices.size() <= this.maxPointsPerNode || currentDepth >= 10) {
            this.octreeIndices.put(currentNode.index, currentNode);
            return;
        }
        currentNode.children = new OctreeNode[8];
        int cnt = 0;
        for (int i : new int[]{-1, 1}) {
            for (int j : new int[]{-1, 1}) {
                for (int k : new int[]{-1, 1}) {
                    OctreeNode node;
                    long index = (i + 1) * 2 + (j + 1) * 1 + (k + 1) / 2;
                    index = currentNode.index | index << 3 * currentDepth + 3;
                    double length = currentNode.getxExtent();
                    Point3d center = new Point3d(currentNode.getCenter().x + (double)i * length / 2.0, currentNode.getCenter().y + (double)j * length / 2.0, currentNode.getCenter().z + (double)k * length / 2.0);
                    currentNode.children[cnt] = node = new OctreeNode(center, length / 2.0, currentDepth + 1);
                    node.index = index;
                    node.indices = new ArrayList<Integer>(currentNode.indices.size() / 8 + 10);
                    ++cnt;
                }
            }
        }
        Object object = currentNode.indices.iterator();
        while (object.hasNext()) {
            int index = (Integer)object.next();
            Point3d point = this.points.get(index);
            Point3d center = currentNode.getCenter();
            int xi = point.x < center.x ? 0 : 1;
            int yj = point.y < center.y ? 0 : 1;
            int zk = point.z < center.z ? 0 : 1;
            int childIndex = xi * 4 + yj * 2 + zk * 1;
            currentNode.children[childIndex].indices.add(index);
        }
        currentNode.indices = null;
        for (OctreeNode node : currentNode.children) {
            this.createOctree(currentDepth + 1, node);
        }
    }

    protected Long locateOctreeNode(OctreeNode node, Point3d point) {
        if (node.children == null) {
            if (node.contains(point)) {
                return node.index;
            }
            throw new IllegalStateException("Search a point exceeding octree bounds.");
        }
        int xi = point.x < node.getCenter().x ? 0 : 1;
        int yj = point.y < node.getCenter().y ? 0 : 1;
        int zk = point.z < node.getCenter().z ? 0 : 1;
        int childIndex = xi * 4 + yj * 2 + zk * 1;
        return this.locateOctreeNode(node.children[childIndex], point);
    }

    private PriorityQueue<Integer> searchNeighborsInNodes(List<Long> candidateLeaves, final Point3d point) {
        int capacity = 0;
        for (long leafIndex : candidateLeaves) {
            capacity += this.octreeIndices.get((Object)Long.valueOf((long)leafIndex)).indices.size();
        }
        PriorityQueue<Integer> queue = new PriorityQueue<Integer>(capacity, new Comparator<Integer>(){

            @Override
            public int compare(Integer pointIndex1, Integer pointIndex2) {
                Point3d p1 = Octree.this.points.get(pointIndex1);
                Point3d p2 = Octree.this.points.get(pointIndex2);
                return Double.compare(p1.distance(point), p2.distance(point));
            }
        });
        for (long leafIndex : candidateLeaves) {
            queue.addAll(this.octreeIndices.get((Object)Long.valueOf((long)leafIndex)).indices);
        }
        return queue;
    }

    public List<Integer> searchNeighborsInSphere(Point3d point, double radius) {
        Integer nextIndex;
        Point3d neighboringPoint;
        ArrayList<Integer> neighborIndices = new ArrayList<Integer>();
        ArrayList<Long> candidateLeaves = new ArrayList<Long>();
        this.determineCandidatesWithinRadius(radius, point, candidateLeaves);
        PriorityQueue<Integer> queue = this.searchNeighborsInNodes(candidateLeaves, point);
        while (queue.size() > 0 && !(point.distance(neighboringPoint = this.points.get(nextIndex = queue.poll())) >= radius)) {
            neighborIndices.add(nextIndex);
        }
        return neighborIndices;
    }

    public List<Integer> searchNeighborsInSphere(int index, double radius) {
        return this.searchNeighborsInSphere(this.points.get(index), radius);
    }

    private void determineCandidatesWithinRadius(double radius, Point3d point, Collection<Long> candidates) {
        Sphere sphere = new Sphere(point, radius);
        ArrayList<OctreeNode> visitingQueue = new ArrayList<OctreeNode>();
        if (Collisions.intersect(this.root, sphere)) {
            visitingQueue.add(this.root);
        }
        for (int currentVisit = 0; currentVisit < visitingQueue.size(); ++currentVisit) {
            OctreeNode visiting = (OctreeNode)visitingQueue.get(currentVisit);
            if (visiting.isLeaf()) {
                if (this.octreeIndices.get(visiting.index) == null) continue;
                candidates.add(visiting.index);
                continue;
            }
            for (OctreeNode child : visiting.children) {
                if (!Collisions.intersect(child, sphere)) continue;
                visitingQueue.add(child);
            }
        }
    }

    public void setMaxPointsPerNode(int m) {
        this.maxPointsPerNode = m;
    }

    public class OctreeNode
    extends Box {
        Long index = 0L;
        List<Integer> indices = null;
        OctreeNode[] children = null;
        int depth = 0;

        OctreeNode(Point3d center, double length, int depth) {
            this.center = new Point3d(center);
            this.xExtent = length;
            this.yExtent = length;
            this.zExtent = length;
            this.depth = depth;
        }

        boolean contains(Point3d point) {
            for (int index : this.indices) {
                if (Octree.this.points.get(index) != point) continue;
                return true;
            }
            return Math.abs(point.x - this.center.x) <= this.xExtent + 1.0E-4 && Math.abs(point.y - this.center.y) <= this.yExtent + 1.0E-4 && Math.abs(point.z - this.center.z) <= this.zExtent + 1.0E-4;
        }

        boolean contains(Point3d point, double tolerance) {
            return Math.abs(Math.abs(point.x - this.center.x) - this.xExtent) <= tolerance && Math.abs(Math.abs(point.y - this.center.y) - this.yExtent) <= tolerance && Math.abs(Math.abs(point.z - this.center.z) - this.zExtent) <= tolerance;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }

        public OctreeNode[] getChildren() {
            return this.children;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isLeaf() {
            return this.children == null;
        }
    }
}

