/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graphics;

import cn.jimmiez.pcu.common.graphics.BoundingBox;
import cn.jimmiez.pcu.util.PcuCommonUtil;
import java.util.List;
import javax.vecmath.Point3d;

public class Normalizer {
    private double length = 1.0;

    public Normalizer() {
        this(1.0);
    }

    public Normalizer(double len) {
        this.length = len;
    }

    public void normalize(List<Point3d> data) {
        BoundingBox box = BoundingBox.of(data);
        double maxLength = 2.0 * PcuCommonUtil.max(box.getxExtent(), box.getyExtent(), box.getzExtent());
        double ratio = this.length / maxLength;
        for (Point3d p : data) {
            p.scale(ratio);
        }
    }

    public double getLength() {
        return this.length;
    }
}

