/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graphics;

import cn.jimmiez.pcu.common.graphics.shape.Box;
import java.util.List;
import javax.vecmath.Point3d;

public class BoundingBox
extends Box {
    public BoundingBox(Box box) {
        this(box.minX(), box.maxX(), box.minY(), box.maxY(), box.minZ(), box.maxZ());
    }

    public BoundingBox() {
        this(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
    }

    public BoundingBox(double minx, double maxx, double miny, double maxy, double minz, double maxz) {
        if (minx > maxx) {
            throw new IllegalArgumentException("minX larger than maxX");
        }
        if (miny > maxy) {
            throw new IllegalArgumentException("minY larger than maxY");
        }
        if (minz > maxz) {
            throw new IllegalArgumentException("minZ larger than maxZ");
        }
        this.center = new Point3d((minx + maxx) / 2.0, (miny + maxy) / 2.0, (minz + maxz) / 2.0);
        this.xExtent = maxx - this.center.x;
        this.yExtent = maxy - this.center.y;
        this.zExtent = maxz - this.center.z;
    }

    private static BoundingBox empty() {
        return new BoundingBox(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public static BoundingBox of(List<Point3d> data) {
        if (data.size() < 1) {
            return BoundingBox.empty();
        }
        double minX = data.get((int)0).x;
        double maxX = data.get((int)0).x;
        double minY = data.get((int)0).y;
        double maxY = data.get((int)0).y;
        double minZ = data.get((int)0).z;
        double maxZ = data.get((int)0).z;
        for (Point3d p : data) {
            minX = Math.min(minX, p.x);
            maxX = Math.max(maxX, p.x);
            minY = Math.min(minY, p.y);
            maxY = Math.max(maxY, p.y);
            minZ = Math.min(minZ, p.z);
            maxZ = Math.max(maxZ, p.z);
        }
        return new BoundingBox(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public double diagonalLength() {
        return 2.0 * Math.sqrt(this.xExtent * this.xExtent + this.yExtent * this.yExtent + this.zExtent * this.zExtent);
    }
}

