/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graph;

import cn.jimmiez.pcu.common.graph.BaseGraph;
import cn.jimmiez.pcu.common.graph.DirectedGraph;
import cn.jimmiez.pcu.common.graph.Graph;
import cn.jimmiez.pcu.util.Pair;
import cn.jimmiez.pcu.util.PcuCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.vecmath.Point3d;

public class Graphs {
    public static List<List<Integer>> connectedComponents(BaseGraph graph) {
        Vector<List<Integer>> subGraphs = new Vector<List<Integer>>();
        HashSet<Integer> visited = new HashSet<Integer>();
        for (int i : graph.vertices()) {
            if (visited.contains(i)) continue;
            ArrayList<Integer> subGraph = new ArrayList<Integer>();
            Vector<Integer> visitQueue = new Vector<Integer>();
            visitQueue.add(i);
            for (int ptr = 0; ptr < visitQueue.size(); ++ptr) {
                int visiting = (Integer)visitQueue.get(ptr);
                if (visited.contains(visiting)) continue;
                visited.add(visiting);
                subGraph.add(visiting);
                for (int adjacentVertex : graph.adjacentVertices(visiting)) {
                    visitQueue.add(adjacentVertex);
                }
            }
            subGraphs.add(subGraph);
        }
        return subGraphs;
    }

    public static BaseGraph subGraph(final BaseGraph graph, final Set<Integer> vertices) {
        final HashMap adjacencyMap = new HashMap();
        for (int vertexIndex : vertices) {
            Collection<Integer> adjacents = graph.adjacentVertices(vertexIndex);
            ArrayList<Integer> adjacentsInSubGraph = new ArrayList<Integer>();
            for (int index : adjacents) {
                if (!vertices.contains(index)) continue;
                adjacentsInSubGraph.add(index);
            }
            adjacencyMap.put(vertexIndex, adjacentsInSubGraph);
        }
        return new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                if (vertices.contains(i) && vertices.contains(j)) {
                    return graph.edgeWeight(i, j);
                }
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public Collection<Integer> adjacentVertices(int i) {
                return (Collection)adjacencyMap.get(i);
            }

            @Override
            public Collection<Integer> vertices() {
                return vertices;
            }
        };
    }

    public static int edgesCountOf(BaseGraph graph) {
        int result = 0;
        for (int vertexIndex : graph.vertices()) {
            result += graph.adjacentVertices(vertexIndex).size();
        }
        return result;
    }

    public static BaseGraph fullConnectedGraph(final List<Point3d> vertices) {
        final Vector<Integer> vt = new Vector<Integer>();
        for (int i = 0; i < vertices.size(); ++i) {
            vt.add(i);
        }
        return new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                return ((Point3d)vertices.get(i)).distance((Point3d)vertices.get(j));
            }

            public List<Integer> adjacentVertices(int i) {
                return vt;
            }

            @Override
            public Collection<Integer> vertices() {
                return vt;
            }
        };
    }

    public static BaseGraph knnGraph(final List<Point3d> vertices, List<int[]> knnIndices) {
        final HashSet<Pair<Integer, Integer>> knnEdges = new HashSet<Pair<Integer, Integer>>();
        final ArrayList<Integer> verticesIndices = new ArrayList<Integer>();
        for (int i = 0; i < knnIndices.size(); ++i) {
            verticesIndices.add(i);
            for (int j : knnIndices.get(i)) {
                knnEdges.add(new Pair<Integer, Integer>(i, j));
            }
        }
        final List<List<Integer>> knnIndicesList = Graphs.adjacentMatrix2List(knnIndices);
        return new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                Pair<Integer, Integer> p = new Pair<Integer, Integer>(i, j);
                if (knnEdges.contains(p)) {
                    return ((Point3d)vertices.get(i)).distance((Point3d)vertices.get(j));
                }
                return Double.POSITIVE_INFINITY;
            }

            public List<Integer> adjacentVertices(int i) {
                return (List)knnIndicesList.get(i);
            }

            @Override
            public Collection<Integer> vertices() {
                return verticesIndices;
            }
        };
    }

    private static List<List<Integer>> adjacentMatrix2List(int[][] adjacency) {
        Vector<List<Integer>> adjacencies = new Vector<List<Integer>>();
        for (int[] adjacencyArray : adjacency) {
            Vector<Integer> vec = new Vector<Integer>();
            for (int index : adjacencyArray) {
                vec.add(index);
            }
            adjacencies.add(vec);
        }
        return adjacencies;
    }

    private static List<List<Integer>> adjacentMatrix2List(List<int[]> adjacency) {
        Vector<List<Integer>> adjacencies = new Vector<List<Integer>>();
        for (int[] adjacencyArray : adjacency) {
            Vector<Integer> vec = new Vector<Integer>();
            for (int index : adjacencyArray) {
                vec.add(index);
            }
            adjacencies.add(vec);
        }
        return adjacencies;
    }

    public static BaseGraph graph(final double[][] edges, int[][] adjacency) {
        final List<List<Integer>> adjacencies = Graphs.adjacentMatrix2List(adjacency);
        final ArrayList<Integer> vertices = PcuCommonUtil.incrementalIntegerList(edges.length);
        return new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                return edges[i][j];
            }

            public List<Integer> adjacentVertices(int i) {
                return (List)adjacencies.get(i);
            }

            @Override
            public Collection<Integer> vertices() {
                return vertices;
            }
        };
    }

    public static Graph knnGraph2(List<int[]> knnIndices, List<Point3d> data) {
        int i;
        DirectedGraph graph = new DirectedGraph();
        for (i = 0; i < knnIndices.size(); ++i) {
            graph.addVertex(i);
        }
        for (i = 0; i < knnIndices.size(); ++i) {
            int[] indices;
            for (int index : indices = knnIndices.get(i)) {
                double dis = data.get(i).distance(data.get(index));
                graph.addEdge(i, index, dis);
                graph.addEdge(index, i, dis);
            }
        }
        return graph;
    }

    public static BaseGraph empty() {
        final ArrayList vertices = new ArrayList();
        return new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                return Double.POSITIVE_INFINITY;
            }

            public List<Integer> adjacentVertices(int i) {
                return new Vector<Integer>();
            }

            @Override
            public Collection<Integer> vertices() {
                return vertices;
            }
        };
    }
}

