/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graph;

import cn.jimmiez.pcu.common.graph.BaseGraph;
import cn.jimmiez.pcu.common.graph.DirectedGraph;
import cn.jimmiez.pcu.common.graph.Graph;
import cn.jimmiez.pcu.common.graph.UndirectedGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class EntityGraph<E>
implements BaseGraph {
    protected Map<Integer, E> values = new HashMap<Integer, E>();
    private AtomicInteger idGenerator = new AtomicInteger();
    private Graph delegate;

    public EntityGraph(boolean directed) {
        this.delegate = directed ? new DirectedGraph() : new UndirectedGraph();
    }

    public int addVertex(E e) {
        int id = this.idGenerator.incrementAndGet();
        this.values.put(id, e);
        this.delegate.addVertex(id);
        return id;
    }

    public void removeVertex(int id) {
        this.values.remove(id);
        this.delegate.removeVertex(id);
    }

    public void removeVertex(E e) {
        for (int key : this.values.keySet()) {
            if (this.values.get(key) != e) continue;
            this.removeVertex(key);
            return;
        }
        System.err.println("Skeleton::removeNode() Cannot find the point.");
    }

    public E getVertex(int id) {
        return this.values.get(id);
    }

    public void addEdge(int i, int j, double weight) {
        this.delegate.addEdge(i, j, weight);
    }

    public void removeEdge(int i, int j) {
        this.delegate.removeEdge(i, j);
    }

    public void clear() {
        this.values.clear();
        this.delegate.clear();
    }

    @Override
    public double edgeWeight(int i, int j) {
        return this.delegate.edgeWeight(i, j);
    }

    @Override
    public Collection<Integer> adjacentVertices(int i) {
        return this.delegate.adjacentVertices(i);
    }

    @Override
    public Collection<Integer> vertices() {
        return this.delegate.vertices();
    }
}

