/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.common.graph;

import cn.jimmiez.pcu.common.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DirectedGraph
implements Graph {
    protected Map<Integer, Map<Integer, Double>> edges = new HashMap<Integer, Map<Integer, Double>>();

    @Override
    public void addEdge(int vi, int vj, double weight) {
        if (this.edges.get(vi) == null) {
            throw new IllegalArgumentException("Invalid index of vi");
        }
        if (this.edges.get(vj) == null) {
            throw new IllegalArgumentException("Invalid index of vj");
        }
        if (weight < 0.0) {
            throw new IllegalArgumentException("Weight must be non-negative.");
        }
        if (vi == vj) {
            return;
        }
        this.edges.get(vi).put(vj, weight);
    }

    @Override
    public void removeEdge(int vi, int vj) {
        if (this.edges.get(vi) == null) {
            throw new IllegalArgumentException("Invalid index of vi");
        }
        if (this.edges.get(vj) == null) {
            throw new IllegalArgumentException("Invalid index of vj");
        }
        if (vi == vj) {
            return;
        }
        this.edges.get(vi).remove(vj);
    }

    @Override
    public void updateEdge(int vi, int vj, double weight) {
        this.addEdge(vi, vj, weight);
    }

    @Override
    public void addVertex(int vi) {
        this.edges.put(vi, new HashMap());
    }

    @Override
    public void removeVertex(int vi) {
        for (int v : this.edges.keySet()) {
            if (!this.edges.get(v).keySet().contains(vi)) continue;
            this.edges.get(v).remove(vi);
        }
        this.edges.remove(vi);
    }

    @Override
    public void clear() {
        this.edges.clear();
    }

    @Override
    public Collection<Integer> vertices() {
        return this.edges.keySet();
    }

    @Override
    public double edgeWeight(int i, int j) {
        if (i == j) {
            return 0.0;
        }
        if (this.edges.get(i) == null) {
            throw new IllegalArgumentException("Invalid index of vi");
        }
        if (this.edges.get(j) == null) {
            throw new IllegalArgumentException("Invalid index of vj");
        }
        Double weight = this.edges.get(i).get(j);
        if (weight == null) {
            return Double.POSITIVE_INFINITY;
        }
        return weight;
    }

    @Override
    public Collection<Integer> adjacentVertices(int i) {
        if (this.edges.get(i) == null) {
            throw new IllegalArgumentException("Invalid index of vi");
        }
        return this.edges.get(i).keySet();
    }

    public boolean hasVertex(int vi) {
        return this.edges.containsKey(vi);
    }
}

