/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.alg.skeleton;

import cn.jimmiez.pcu.alg.skeleton.Skeletonization;
import cn.jimmiez.pcu.common.graph.BaseGraph;
import cn.jimmiez.pcu.common.graph.DirectedGraph;
import cn.jimmiez.pcu.common.graph.Graph;
import cn.jimmiez.pcu.common.graph.Graphs;
import cn.jimmiez.pcu.common.graph.ShortestPath;
import cn.jimmiez.pcu.common.graphics.Octree;
import cn.jimmiez.pcu.model.Skeleton;
import cn.jimmiez.pcu.util.Pair;
import cn.jimmiez.pcu.util.PcuCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Point3d;

public class LevelSetSkeleton
implements Skeletonization {
    private List<Point3d> data;
    private Octree octree = null;
    private BaseGraph neighborhoodGraph = null;
    private BaseGraph geodesicGraph = null;
    private List<LevelSet> levelSets = null;
    private List<Double> distanceMap = null;
    private Map<Integer, Pair<List<Integer>, Double>> paths;
    private Skeleton skeleton = null;
    private static final int INVALID_INDEX = -1;
    private static final int MIN_DATA_SIZE = 3;
    private static int RANDOM_SOURCE_INDEX = 0;
    private static int DEFAULT_LEVEL_NUM = 20;
    private int source = -1;
    private int n = 5;
    private int k = DEFAULT_LEVEL_NUM;
    private double alpha = 0.03;
    private double beta = 0.97;

    private void init() {
        if (this.data.size() < 3) {
            throw new IllegalStateException("Too few points provided.");
        }
        this.skeleton = new Skeleton();
        this.distanceMap = new Vector<Double>();
        this.paths = new HashMap<Integer, Pair<List<Integer>, Double>>();
        this.octree = new Octree();
        this.octree.buildIndex(this.data);
        this.n = Math.min(this.data.size(), this.n);
    }

    private void clean() {
        this.octree = null;
        this.distanceMap = null;
        this.neighborhoodGraph = null;
        this.geodesicGraph = null;
        this.paths = null;
        this.levelSets = null;
        this.source = -1;
    }

    private void buildNeighborhoodGraph(int n) {
        Vector<int[]> nnIndices = new Vector<int[]>();
        for (int i = 0; i < this.data.size(); ++i) {
            int[] neighborIndices = this.octree.searchNearestNeighbors(n, i);
            nnIndices.add(neighborIndices);
        }
        this.neighborhoodGraph = Graphs.knnGraph(this.data, nnIndices);
        this.checkConnectivity();
    }

    private void checkConnectivity() {
        List<List<Integer>> subGraphs = Graphs.connectedComponents(this.neighborhoodGraph);
        if (subGraphs.size() != 1) {
            System.out.println("Current n is " + this.n);
            throw new IllegalStateException("The neighborhood graph is not a connected graph. You can specify a larger n by calling setN().");
        }
    }

    private void buildGeodesicGraph() {
        int i;
        if (this.source < 0 || this.source >= this.data.size()) {
            throw new IllegalStateException("The index of source point is invalid.");
        }
        this.paths = ShortestPath.dijkstra(this.neighborhoodGraph, this.source);
        final Vector edges = new Vector();
        final ArrayList<Integer> vertices = PcuCommonUtil.incrementalIntegerList(this.data.size());
        HashSet<Pair<Integer, Integer>> edgesSet = new HashSet<Pair<Integer, Integer>>();
        for (i = 0; i < this.data.size(); ++i) {
            edges.add(new Vector());
        }
        for (i = 0; i < this.paths.size(); ++i) {
            Pair<List<Integer>, Double> pair = this.paths.get(i);
            this.distanceMap.add(pair.getValue());
            List<Integer> path = pair.getKey();
            for (int j = 1; j < path.size(); ++j) {
                int currNodeIndex;
                int prevNodeIndex = path.get(j - 1);
                if (prevNodeIndex == (currNodeIndex = path.get(j).intValue())) continue;
                Pair<Integer, Integer> edge1 = new Pair<Integer, Integer>(prevNodeIndex, currNodeIndex);
                Pair<Integer, Integer> edge2 = new Pair<Integer, Integer>(currNodeIndex, prevNodeIndex);
                if (!edgesSet.contains(edge1)) {
                    ((List)edges.get(prevNodeIndex)).add(currNodeIndex);
                    edgesSet.add(edge1);
                }
                if (edgesSet.contains(edge2)) continue;
                ((List)edges.get(currNodeIndex)).add(prevNodeIndex);
                edgesSet.add(edge2);
            }
        }
        this.geodesicGraph = new BaseGraph(){

            @Override
            public double edgeWeight(int i, int j) {
                return ((Point3d)LevelSetSkeleton.this.data.get(i)).distance((Point3d)LevelSetSkeleton.this.data.get(j));
            }

            public List<Integer> adjacentVertices(int i) {
                return (List)edges.get(i);
            }

            @Override
            public Collection<Integer> vertices() {
                return vertices;
            }
        };
    }

    private void divideLevelSets() {
        int i;
        int furthestPointIndex = 0;
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (!(this.distanceMap.get(furthestPointIndex) < this.distanceMap.get(i2))) continue;
            furthestPointIndex = i2;
        }
        this.computeEmpiricalK(furthestPointIndex);
        if (this.k < 1 || this.k >= this.data.size()) {
            throw new IllegalStateException("Improper k is set.");
        }
        double intervalLowerBound = this.distanceMap.get(furthestPointIndex) * this.alpha;
        double intervalUpperBound = this.distanceMap.get(furthestPointIndex) * this.beta;
        double subInterval = (intervalUpperBound - intervalLowerBound) / (double)this.k;
        this.levelSets = new Vector<LevelSet>();
        for (i = 0; i < this.k + 2; ++i) {
            this.levelSets.add(new LevelSet());
        }
        for (i = 0; i < this.data.size(); ++i) {
            double geodesicDistance = this.distanceMap.get(i);
            if (geodesicDistance <= intervalLowerBound) {
                this.levelSets.get(0).addPoint(this.data.get(i), i);
                continue;
            }
            if (geodesicDistance >= intervalUpperBound) {
                this.levelSets.get(this.k + 1).addPoint(this.data.get(i), i);
                continue;
            }
            int levelSetPosition = (int)((geodesicDistance - intervalLowerBound) / subInterval) + 1;
            this.levelSets.get(levelSetPosition).addPoint(this.data.get(i), i);
        }
    }

    private void computeEmpiricalK(int furthestPointIndex) {
    }

    private void generateResultingSkeleton() {
        int subGraphIndex;
        int levelSetIndex;
        LevelSet levelSet2;
        for (LevelSet levelSet2 : this.levelSets) {
            levelSet2.partition();
        }
        for (levelSetIndex = 0; levelSetIndex < this.levelSets.size(); ++levelSetIndex) {
            levelSet2 = this.levelSets.get(levelSetIndex);
            for (subGraphIndex = 0; subGraphIndex < levelSet2.subGraphs.size(); ++subGraphIndex) {
                Pair<Integer, Integer> pair = this.searchAdjacentSkeletonPoint(levelSetIndex, subGraphIndex);
                levelSet2.adjacency.add(pair);
            }
        }
        for (levelSetIndex = 0; levelSetIndex < this.levelSets.size(); ++levelSetIndex) {
            levelSet2 = this.levelSets.get(levelSetIndex);
            for (subGraphIndex = 0; subGraphIndex < levelSet2.subGraphs.size(); ++subGraphIndex) {
                List<Integer> subGraph = levelSet2.subGraphs.get(subGraphIndex);
                int nodeId = this.skeleton.addVertex(this.baryCenter(levelSet2.points, subGraph));
                levelSet2.skeletonNodeIndices.add(nodeId);
            }
        }
        for (levelSetIndex = 0; levelSetIndex < this.levelSets.size(); ++levelSetIndex) {
            levelSet2 = this.levelSets.get(levelSetIndex);
            for (subGraphIndex = 0; subGraphIndex < levelSet2.subGraphs.size(); ++subGraphIndex) {
                int v1 = levelSet2.skeletonNodeIndices.get(subGraphIndex);
                int adjacentLevelSetIndex = levelSet2.adjacency.get(subGraphIndex).getKey();
                int adjacentSubGraphIndex = levelSet2.adjacency.get(subGraphIndex).getValue();
                int v2 = this.levelSets.get((int)adjacentLevelSetIndex).skeletonNodeIndices.get(adjacentSubGraphIndex);
                double weight = ((Point3d)this.skeleton.getVertex(v1)).distance((Point3d)this.skeleton.getVertex(v2));
                this.skeleton.addEdge(v1, v2, weight);
            }
        }
    }

    private Point3d baryCenter(List<Point3d> points, List<Integer> indices) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Integer index : indices) {
            x += points.get((int)index.intValue()).x;
            y += points.get((int)index.intValue()).y;
            z += points.get((int)index.intValue()).z;
        }
        return new Point3d(x / (double)indices.size(), y / (double)indices.size(), z / (double)indices.size());
    }

    private Pair<Integer, Integer> searchAdjacentSkeletonPoint(int levelSetIndex, int subGraphIndex) {
        if (levelSetIndex < 0) {
            throw new IllegalArgumentException("Negative index of level set.");
        }
        if (levelSetIndex == 0) {
            return new Pair<Integer, Integer>(levelSetIndex, subGraphIndex);
        }
        LevelSet levelSet = this.levelSets.get(levelSetIndex);
        List<Integer> subGraph = levelSet.subGraphs.get(subGraphIndex);
        int randomPointIndex = levelSet.indexInPointCloud.get(subGraph.get(0));
        List<Integer> path = this.paths.get(randomPointIndex).getKey();
        for (int i = path.size() - 1; i >= 0; --i) {
            int nextPointIndex = path.get(i);
            Point3d nextPoint = this.data.get(nextPointIndex);
            if (levelSet.indexInPointCloud.contains(nextPointIndex)) continue;
            LevelSet lowerLevelSet = this.levelSets.get(levelSetIndex - 1);
            for (int j = 0; j < lowerLevelSet.subGraphs.size(); ++j) {
                List<Integer> lowerSubGraph = lowerLevelSet.subGraphs.get(j);
                for (int pointLocalIndex : lowerSubGraph) {
                    if (lowerLevelSet.points.get(pointLocalIndex) != nextPoint) continue;
                    return new Pair<Integer, Integer>(levelSetIndex - 1, j);
                }
            }
        }
        System.err.println("LevelSetSkeleton::searchAdjacentSkeletonPoint(): Cannot find a connected component containing the point on the shortest path.");
        return new Pair<Integer, Integer>(levelSetIndex, subGraphIndex);
    }

    private void determineSourcePoint() {
        if (this.source != -1) {
            return;
        }
        Map<Integer, Pair<List<Integer>, Double>> paths = ShortestPath.dijkstra(this.neighborhoodGraph, RANDOM_SOURCE_INDEX);
        double maximalDistance = Double.MIN_VALUE;
        for (int i = 0; i < paths.size(); ++i) {
            Pair<List<Integer>, Double> pair = paths.get(i);
            if (!(pair.getValue() > maximalDistance)) continue;
            maximalDistance = pair.getValue();
            this.source = i;
        }
    }

    @Override
    public Skeleton skeletonize(List<Point3d> pointCloud) {
        this.data = pointCloud;
        this.init();
        this.buildNeighborhoodGraph(this.n);
        this.determineSourcePoint();
        this.buildGeodesicGraph();
        this.divideLevelSets();
        this.generateResultingSkeleton();
        this.clean();
        return this.skeleton;
    }

    public void setRoot(int p) {
        this.source = p;
    }

    public int getRoot() {
        return this.source;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    public BaseGraph getNeighborhoodGraph() {
        return this.neighborhoodGraph;
    }

    private static class LevelSet {
        List<Point3d> points = new Vector<Point3d>();
        List<Integer> indexInPointCloud = new Vector<Integer>();
        List<List<Integer>> subGraphs = null;
        List<Pair<Integer, Integer>> adjacency = new Vector<Pair<Integer, Integer>>();
        List<Integer> skeletonNodeIndices = new Vector<Integer>();

        private LevelSet() {
        }

        public void addPoint(Point3d p, int i) {
            this.points.add(p);
            this.indexInPointCloud.add(i);
        }

        void removeEdges(Graph graph, double sum) {
            double wi = sum / (double)graph.vertices().size();
            Vector<int[]> edges = new Vector<int[]>();
            for (Integer vi : graph.vertices()) {
                for (Integer vj : graph.adjacentVertices(vi)) {
                    double weight = graph.edgeWeight(vi, vj);
                    if (!(weight >= wi)) continue;
                    edges.add(new int[]{vi, vj});
                    edges.add(new int[]{vj, vi});
                }
            }
            for (int[] edge : edges) {
                graph.removeEdge(edge[0], edge[1]);
            }
        }

        void partition() {
            int i;
            Octree octree = new Octree();
            octree.buildIndex(this.points);
            DirectedGraph graph = new DirectedGraph();
            double secondaryEdgeSum = 0.0;
            for (i = 0; i < this.points.size(); ++i) {
                graph.addVertex(i);
            }
            for (i = 0; i < this.points.size(); ++i) {
                int[] indices = octree.searchNearestNeighbors(10, i);
                for (int j = 0; j < indices.length; ++j) {
                    int index = indices[j];
                    double dis = this.points.get(i).distance(this.points.get(index));
                    if (j == indices.length - 1) {
                        secondaryEdgeSum += dis;
                    }
                    graph.addEdge(i, index, dis);
                    graph.addEdge(index, i, dis);
                }
            }
            this.subGraphs = Graphs.connectedComponents(graph);
        }
    }
}

