/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.alg.sampler;

import cn.jimmiez.pcu.common.graphics.BoundingBox;
import cn.jimmiez.pcu.common.graphics.Octree;
import cn.jimmiez.pcu.common.graphics.shape.Box;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class GridVoxelizer {
    private Map<Long, GridCell> cellMap = new HashMap<Long, GridCell>();
    private List<Point3d> points;
    private Box gridBox = null;
    private int xCount = -1;
    private int yCount = -1;
    private int zCount = -1;
    private double cellSize = -1.0;
    private double cellRatio = -1.0;
    private boolean specifyCellSize = false;

    public GridVoxelizer() {
        this(2.5);
    }

    public GridVoxelizer(double ratio) {
        this.cellRatio = ratio;
    }

    public List<GridCell> voxelize(List<Point3d> points) {
        return this.voxelize(points, -1.0);
    }

    public List<GridCell> voxelize(List<Point3d> points, double cellSize) {
        this.points = points;
        if (cellSize > 0.0) {
            this.specifyCellSize = true;
        }
        this.cellSize = cellSize;
        this.determineVoxelNumber();
        this.divideVoxelImpl();
        ArrayList<GridCell> list = new ArrayList<GridCell>();
        list.addAll(this.cellMap.values());
        return list;
    }

    private void determineVoxelNumber() {
        BoundingBox tightBox = BoundingBox.of(this.points);
        if (!this.specifyCellSize) {
            Octree octree = new Octree();
            octree.buildIndex(this.points);
            double lengthSum = 0.0;
            int edgeCnt = 0;
            int sampleCnt = Math.min(this.points.size(), Math.max(this.points.size() / 15, 1000));
            Random random = new Random(System.currentTimeMillis());
            for (int i = 0; i < sampleCnt; ++i) {
                int randomIndex = random.nextInt(this.points.size());
                Point3d point = this.points.get(randomIndex);
                for (int index : octree.searchNearestNeighbors(3, randomIndex)) {
                    Point3d neighbor = this.points.get(index);
                    Vector3d vector = new Vector3d(neighbor.x - point.x, neighbor.y - point.y, neighbor.z - point.z);
                    lengthSum += vector.length();
                    ++edgeCnt;
                }
            }
            double averageLength = lengthSum / (double)edgeCnt;
            this.cellSize = averageLength * this.cellRatio;
            this.gridBox = new Box(tightBox.getCenter(), tightBox.getxExtent() + averageLength, tightBox.getyExtent() + averageLength, tightBox.getzExtent() + averageLength);
        } else {
            double tolerance = this.cellSize * 0.3;
            this.gridBox = new Box(tightBox.getCenter(), tightBox.getxExtent() + tolerance, tightBox.getyExtent() + tolerance, tightBox.getzExtent() + tolerance);
        }
        this.xCount = (int)Math.ceil(this.gridBox.getxExtent() * 2.0 / this.cellSize);
        this.yCount = (int)Math.ceil(this.gridBox.getyExtent() * 2.0 / this.cellSize);
        this.zCount = (int)Math.ceil(this.gridBox.getzExtent() * 2.0 / this.cellSize);
    }

    private void divideVoxelImpl() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point3d p = this.points.get(i);
            long index = this.findVoxel(p);
            if (this.cellMap.get(index) == null) {
                this.cellMap.put(index, new GridCell(index));
            }
            this.cellMap.get(index).indices.add(i);
        }
    }

    private long findVoxel(Point3d point) {
        int x = (int)((point.x - this.gridBox.minX()) / this.cellSize);
        int y = (int)((point.y - this.gridBox.minY()) / this.cellSize);
        int z = (int)((point.z - this.gridBox.minZ()) / this.cellSize);
        x = Math.min(x, this.xCount - 1);
        y = Math.min(y, this.yCount - 1);
        z = Math.min(z, this.zCount - 1);
        return this.indexOfCell(x, y, z);
    }

    private Long indexOfCell(int xRow, int yRow, int zRow) {
        long index = zRow;
        index <<= 20;
        index |= (long)yRow;
        index <<= 20;
        return index |= (long)xRow;
    }

    private int[] parseIndex(long index) {
        int[] coordinates = new int[3];
        long mask = 0xFFFFFFL;
        coordinates[0] = (int)(index & mask);
        coordinates[1] = (int)(index >> 20 & mask);
        coordinates[2] = (int)(index >> 40 & mask);
        return coordinates;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public class GridCell {
        private Long index;
        private List<Integer> indices = new ArrayList<Integer>();

        public GridCell(Long index) {
            this.index = index;
        }

        public Long getIndex() {
            return this.index;
        }

        public List<Integer> getIndices() {
            return this.indices;
        }
    }
}

