/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.alg.projector;

import cn.jimmiez.pcu.common.graphics.BoundingBox;
import cn.jimmiez.pcu.common.graphics.Octree;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class WeightedLocallyOptimalProjector {
    private List<Point3d> originals = null;
    private List<Point3d> samples = null;
    private List<List<Integer>> sampleOriginalNeighbors = new ArrayList<List<Integer>>();
    private List<List<Integer>> sampleSelfNeighbors = new ArrayList<List<Integer>>();
    private List<List<Integer>> originalSelfNeighbors = new ArrayList<List<Integer>>();
    private List<Double> sampleDensity = new ArrayList<Double>();
    private List<Double> originalDensity = new ArrayList<Double>();
    private double h = 0.1;
    private double repulsionMu = 0.5;
    private Octree originalOctree;

    public WeightedLocallyOptimalProjector(List<Point3d> originals) {
        this.originals = originals;
        this.originalOctree = new Octree();
        this.originalOctree.buildIndex(originals);
        for (int i = 0; i < originals.size(); ++i) {
            this.originalDensity.add(1.0);
        }
        BoundingBox box = BoundingBox.of(originals);
        this.h = 4.0 * Math.sqrt(box.diagonalLength() / (double)originals.size());
    }

    private double theta(double distance) {
        return Math.pow(Math.E, -4.0 * distance * distance / this.h / this.h);
    }

    private void run(int iterNum) {
        for (int i = 0; i < iterNum; ++i) {
            System.out.print("\rh:" + this.h);
            this.iterate(i);
        }
    }

    private void computeAverageTerm(List<Vector3d> averageVectors, List<Double> averageWeightSums) {
        averageVectors.clear();
        averageWeightSums.clear();
        for (int i = 0; i < this.samples.size(); ++i) {
            Point3d sample = this.samples.get(i);
            double averageWeightSum = 0.0;
            Vector3d delta = new Vector3d();
            for (int originalNeighborIndex : this.sampleOriginalNeighbors.get(i)) {
                Point3d neighborPoint = this.originals.get(originalNeighborIndex);
                double distance = sample.distance(neighborPoint);
                distance = Math.max(this.h * 0.01, distance);
                double averageWeight = this.theta(distance) / distance;
                Vector3d deltaj = new Vector3d((Tuple3d)neighborPoint);
                deltaj.scale(averageWeight *= this.originalDensity.get(originalNeighborIndex).doubleValue());
                delta.add((Tuple3d)deltaj);
                averageWeightSum += averageWeight;
            }
            averageWeightSums.add(averageWeightSum);
            averageVectors.add(delta);
        }
    }

    private void computeRepulsionTerm(List<Vector3d> repulsionVectors, List<Double> repulsionWeightSums) {
        repulsionVectors.clear();
        repulsionWeightSums.clear();
        for (int i = 0; i < this.samples.size(); ++i) {
            Point3d sample = this.samples.get(i);
            Vector3d delta = new Vector3d();
            double repulsionWeightSum = 0.0;
            for (int neighborIndex : this.sampleSelfNeighbors.get(i)) {
                if (i == neighborIndex) continue;
                Point3d neighborPoint = this.samples.get(neighborIndex);
                double distance = neighborPoint.distance(sample);
                distance = Math.max(this.h * 0.01, distance);
                double repulsionWeight = this.theta(distance) / Math.pow(distance, 4.0);
                Vector3d neighborSampleVec = new Vector3d(sample.x - neighborPoint.x, sample.y - neighborPoint.y, sample.z - neighborPoint.z);
                neighborSampleVec.scale(repulsionWeight *= this.sampleDensity.get(neighborIndex).doubleValue());
                repulsionWeightSum += repulsionWeight;
                delta.add((Tuple3d)neighborSampleVec);
            }
            repulsionWeightSums.add(repulsionWeightSum);
            repulsionVectors.add(delta);
        }
    }

    private void computeDensity(List<Point3d> points, List<Double> densities, List<List<Integer>> neighborList, double h, boolean original) {
        for (int i = 0; i < points.size(); ++i) {
            double density = 1.0;
            Point3d point = points.get(i);
            List<Integer> neighbors = neighborList.get(i);
            for (int neighborIndex : neighbors) {
                Point3d neighbor = points.get(neighborIndex);
                double distance = point.distance(neighbor);
                double den = this.theta(distance);
                density += den;
            }
            density = original ? 1.0 / density : Math.sqrt(density);
            densities.set(i, density);
        }
    }

    private void iterate(int iter) {
        Octree sampleOctree = new Octree();
        sampleOctree.buildIndex(this.samples);
        this.sampleSelfNeighbors.clear();
        this.sampleOriginalNeighbors.clear();
        this.originalSelfNeighbors.clear();
        for (int i = 0; i < this.samples.size(); ++i) {
            this.sampleSelfNeighbors.add(sampleOctree.searchNeighborsInSphere(i, this.h));
            this.sampleOriginalNeighbors.add(this.originalOctree.searchNeighborsInSphere(this.samples.get(i), this.h));
        }
        double MAGIC_RATIO = 0.95;
        if (iter == 0) {
            for (int i = 0; i < this.originals.size(); ++i) {
                this.originalSelfNeighbors.add(this.originalOctree.searchNeighborsInSphere(i, this.h));
            }
            this.computeDensity(this.originals, this.originalDensity, this.originalSelfNeighbors, this.h * 0.95, true);
        }
        this.computeDensity(this.samples, this.sampleDensity, this.sampleSelfNeighbors, this.h, false);
        ArrayList<Double> averageWeightSums = new ArrayList<Double>();
        ArrayList<Double> repulsionWeightSums = new ArrayList<Double>();
        ArrayList<Vector3d> averageVectors = new ArrayList<Vector3d>();
        ArrayList<Vector3d> repulsionVectors = new ArrayList<Vector3d>();
        this.computeAverageTerm(averageVectors, averageWeightSums);
        this.computeRepulsionTerm(repulsionVectors, repulsionWeightSums);
        for (int i = 0; i < this.samples.size(); ++i) {
            Point3d sample = this.samples.get(i);
            double averageWeightSum = (Double)averageWeightSums.get(i);
            double repulsionWeightSum = (Double)repulsionWeightSums.get(i);
            Vector3d averageVector = (Vector3d)averageVectors.get(i);
            Vector3d repulsionVector = (Vector3d)repulsionVectors.get(i);
            if (averageWeightSum > 1.0E-6) {
                averageVector.scale(1.0 / averageWeightSum);
                sample.set((Tuple3d)averageVector);
            }
            if (!(repulsionWeightSum > 1.0E-6) || !(this.repulsionMu >= 0.0)) continue;
            repulsionVector.scale(this.repulsionMu / repulsionWeightSum);
            sample.add((Tuple3d)repulsionVector);
        }
    }

    public void project(List<Point3d> samples, int iterNum) {
        this.samples = samples;
        this.sampleDensity.clear();
        for (int i = 0; i < samples.size(); ++i) {
            this.sampleDensity.add(1.0);
        }
        this.run(iterNum);
    }

    public void setH(double h) {
        this.h = h;
    }

    public void setRepulsionMu(double repulsionMu) {
        this.repulsionMu = repulsionMu;
    }
}

