/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.alg.projector;

import cn.jimmiez.pcu.common.graphics.BoundingBox;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class LocallyOptimalProjector {
    private List<Point3d> data;
    private int k;
    private double h;
    private double miu = 0.4;

    public LocallyOptimalProjector(List<Point3d> data, int k) {
        this.data = data;
        this.k = k;
        this.h = this.defaultH();
    }

    private double defaultH() {
        if (this.data == null || this.data.size() < 1) {
            return 1.0;
        }
        BoundingBox box = BoundingBox.of(this.data);
        return box.diagonalLength() / (double)this.data.size() * 4.0;
    }

    private double theta(double distance) {
        return Math.pow(Math.E, -4.0 * distance * distance / this.h / this.h);
    }

    private void firstIteration(List<Point3d> projectedResults, List<Point3d> tobeProjected) {
        projectedResults.clear();
        for (int i1 = 0; i1 < tobeProjected.size(); ++i1) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double denominator = 0.0;
            for (int j = 0; j < this.data.size(); ++j) {
                double distance = this.data.get(j).distance(tobeProjected.get(i1));
                double thetaValue = this.theta(distance);
                x += this.data.get((int)j).x * thetaValue;
                y += this.data.get((int)j).y * thetaValue;
                z += this.data.get((int)j).z * thetaValue;
                denominator += thetaValue;
            }
            projectedResults.add(new Point3d(x /= denominator, y /= denominator, z /= denominator));
        }
    }

    private double alpha(Point3d xi1k, Point3d pj) {
        double normXi1Pj = xi1k.distance(pj);
        if (Math.abs(normXi1Pj) < 1.0E-7) {
            return 0.0;
        }
        return this.theta(normXi1Pj) / normXi1Pj;
    }

    private double beta(Point3d xi1k, Point3d xik) {
        double normXi1Xi = xi1k.distance(xik);
        if (Math.abs(normXi1Xi) < 1.0E-7) {
            return 0.0;
        }
        return this.theta(normXi1Xi) / Math.pow(normXi1Xi, 5.0);
    }

    private void successiveIteration(List<Point3d> projectedResults) {
        ArrayList<Point3d> nextIterPoints = new ArrayList<Point3d>();
        for (int i1 = 0; i1 < projectedResults.size(); ++i1) {
            Point3d xik;
            int i;
            Point3d pj;
            int j;
            Point3d xi1k = projectedResults.get(i1);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double[] alphas = new double[this.data.size()];
            double alphaSum = 0.0;
            for (j = 0; j < this.data.size(); ++j) {
                if (i1 == j) continue;
                pj = this.data.get(j);
                alphas[j] = this.alpha(xi1k, pj);
                alphaSum += alphas[j];
            }
            for (j = 0; j < this.data.size(); ++j) {
                pj = this.data.get(j);
                x += pj.x * alphas[j] / alphaSum;
                y += pj.y * alphas[j] / alphaSum;
                z += pj.z * alphas[j] / alphaSum;
            }
            double[] betas = new double[projectedResults.size()];
            double betaSum = 0.0;
            for (i = 0; i < projectedResults.size(); ++i) {
                if (i == i1) continue;
                xik = projectedResults.get(i);
                betas[i] = this.beta(xik, xi1k);
                betaSum += betas[i];
            }
            for (i = 0; i < projectedResults.size(); ++i) {
                if (i == i1) continue;
                xik = projectedResults.get(i);
                x += this.miu * (xi1k.x - xik.x) * betas[i] / betaSum;
                y += this.miu * (xi1k.y - xik.y) * betas[i] / betaSum;
                z += this.miu * (xi1k.z - xik.z) * betas[i] / betaSum;
            }
            nextIterPoints.add(new Point3d(x, y, z));
        }
        projectedResults.clear();
        projectedResults.addAll(nextIterPoints);
        nextIterPoints.clear();
    }

    public List<Point3d> project(List<Point3d> tobeProjected) {
        ArrayList<Point3d> projectedPoints = new ArrayList<Point3d>();
        this.firstIteration(projectedPoints, tobeProjected);
        for (int kIter = 0; kIter < this.k; ++kIter) {
            this.successiveIteration(projectedPoints);
        }
        return projectedPoints;
    }
}

