/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmiez.pcu.alg.normal;

import Jama.Matrix;
import cn.jimmiez.pcu.alg.normal.NormalEstimator;
import cn.jimmiez.pcu.common.graphics.Octree;
import com.mkobos.pca_transform.covmatrixevd.EVD;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class HoppeEstimator
implements NormalEstimator {
    private final int MINIMAL_POINTS = 5;

    @Override
    public List<Vector3d> estimateNormals(List<Point3d> data) {
        if (data.size() < 5) {
            throw new IllegalArgumentException("Too few points given! The size of point cloud is expected to be larger than 5");
        }
        int k = this.defaultNeighborhoodSize(data);
        Vector<Vector3d> normals = new Vector<Vector3d>();
        Octree octree = new Octree();
        octree.buildIndex(data);
        for (int i = 0; i < data.size(); ++i) {
            int[] neighborIndices = octree.searchNearestNeighbors(k, i);
            normals.add(this.estimateNormal(data, i, neighborIndices));
        }
        return normals;
    }

    private Vector3d estimateNormal(List<Point3d> data, int index, int[] neighborIndices) {
        Vector3d normal = new Vector3d();
        Point3d oi = new Point3d(data.get(index));
        for (int neighborIndex : neighborIndices) {
            oi.add((Tuple3d)data.get(neighborIndex));
        }
        oi.scale(1.0 / (double)(neighborIndices.length + 1));
        double[][] covMatrixData = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        for (int neighborIndex : neighborIndices) {
            Point3d y = data.get(neighborIndex);
            Vector3d oiy = new Vector3d(y.x - oi.x, y.y - oi.y, y.z - oi.z);
            double[] dArray = covMatrixData[0];
            dArray[0] = dArray[0] + oiy.x * oiy.x;
            double[] dArray2 = covMatrixData[0];
            dArray2[1] = dArray2[1] + oiy.x * oiy.y;
            double[] dArray3 = covMatrixData[0];
            dArray3[2] = dArray3[2] + oiy.x * oiy.z;
            double[] dArray4 = covMatrixData[1];
            dArray4[0] = dArray4[0] + oiy.y * oiy.x;
            double[] dArray5 = covMatrixData[1];
            dArray5[1] = dArray5[1] + oiy.y * oiy.y;
            double[] dArray6 = covMatrixData[1];
            dArray6[2] = dArray6[2] + oiy.y * oiy.z;
            double[] dArray7 = covMatrixData[2];
            dArray7[0] = dArray7[0] + oiy.z * oiy.x;
            double[] dArray8 = covMatrixData[2];
            dArray8[1] = dArray8[1] + oiy.z * oiy.y;
            double[] dArray9 = covMatrixData[2];
            dArray9[2] = dArray9[2] + oiy.z * oiy.z;
        }
        for (int row = 0; row < 3; ++row) {
            int col = 0;
            while (col < 3) {
                double[] dArray = covMatrixData[row];
                int n = col++;
                dArray[n] = dArray[n] / (double)neighborIndices.length;
            }
        }
        Matrix cv = new Matrix((double[][])covMatrixData);
        EVD evd = new EVD(cv);
        Matrix eigenVectorMatrix = evd.v;
        normal.x = eigenVectorMatrix.get(0, 2);
        normal.y = eigenVectorMatrix.get(1, 2);
        normal.z = eigenVectorMatrix.get(2, 2);
        normal.normalize();
        return normal;
    }

    private int defaultNeighborhoodSize(List<Point3d> data) {
        return Math.max(4, 16);
    }
}

