/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.task.core;

import cn.hutool.core.util.EnumUtil;
import cn.jiiiiiin.mvc.common.utils.IPUtil;
import cn.jiiiiiin.task.core.ITask;
import cn.jiiiiiin.task.core.TaskException;
import cn.jiiiiiin.task.entity.TaskRecords;
import cn.jiiiiiin.task.mapper.TaskRecordsMapper;
import cn.jiiiiiin.task.service.ITaskRecordsSvc;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Date;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskTmpl {
    private static final Logger log = LoggerFactory.getLogger(TaskTmpl.class);
    private final ITaskRecordsSvc taskRecordsSvc;
    private final TaskRecordsMapper taskRecordsMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NonNull ITask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        String taskId = task.getId();
        log.info("=== taskTmpl execute \u51c6\u5907\u6267\u884c\u4efb\u52a1 {} ===", (Object)taskId);
        if (this.checkCurrStatusIsOk(task)) {
            log.info("\u5f53\u5929\u5df2\u7ecf\u6267\u884c\u6210\u529f\u8fc7 {} taskTmpl \u5b8c\u7ed3", (Object)task.getId());
            return;
        }
        if (task.isNeedCheckIntervalTimeIsProcess()) {
            TaskRecords processRecords = this.checkIntervalTimeIsProcess(task);
            task.onTaskIsProcess(processRecords);
        }
        if (task.isNeedRunTask()) {
            log.info("{} \u4efb\u52a1\u51c6\u5907\u5f00\u59cb\u6267\u884c", (Object)taskId);
            TaskRecords currRecords = this._insertReportRecords(task);
            log.info("{} \u4efb\u52a1\u8bb0\u5f55\u767b\u8bb0\u4e3a\u6267\u884c\u4e2d {}", (Object)taskId, (Object)currRecords);
            boolean processStatus = false;
            try {
                processStatus = task.runTask(currRecords);
                log.info("{} \u4efb\u52a1\u5185\u90e8\u6d41\u7a0b\u652f\u6301\u6210\u529f", (Object)taskId);
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u5185\u90e8\u6d41\u7a0b\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this._updateCurrRecordsStatus(processStatus, currRecords);
                log.info("{} \u4efb\u52a1\u66f4\u65b0\u8bb0\u5f55\u767b\u8bb0 {}", (Object)taskId, (Object)currRecords);
                log.info("=== taskTmpl execute \u4efb\u52a1{}\u6267\u884c\u5b8c\u6bd5 ===", (Object)taskId);
            }
        }
    }

    private TaskRecords checkIntervalTimeIsProcess(@NonNull ITask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        ITask.IntervalFlag INTERVAL_FLAG = task.getIntervalFlag();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaskRecords::getTaskId, (Object)task.getId())).eq(TaskRecords::getStatus, (Object)TaskRecords.FieldDict.STATUS_PROCESSING.getValue())).apply(INTERVAL_FLAG.equals((Object)ITask.IntervalFlag.D), "to_days(process_date) = to_days(now())", new Object[0])).apply(INTERVAL_FLAG.equals((Object)ITask.IntervalFlag.M), "date_format(process_date, '%Y%m') = date_format(curdate() , '%Y%m')", new Object[0]);
        return (TaskRecords)this.taskRecordsSvc.getOne((Wrapper)queryWrapper);
    }

    private boolean checkCurrStatusIsOk(@NonNull ITask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (task.needCheckIntervalTimeTaskStatus()) {
            log.info("\u68c0\u67e5\u5f53\u5929\u662f\u5426\u5df2\u7ecf\u6267\u884c\u6210\u529f\u8fc7 {}", (Object)task.getId());
            return this.intervalTimeIsOk(task);
        }
        return false;
    }

    private boolean intervalTimeIsOk(@NonNull ITask task) {
        boolean isProcessOk;
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        ITask.IntervalFlag INTERVAL_FLAG = task.getIntervalFlag();
        boolean contains = EnumUtil.contains(ITask.IntervalFlag.class, (String)INTERVAL_FLAG.name());
        if (!contains) {
            throw new TaskException(TaskException.ERR.NO_SUPPORT_PS_PR);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaskRecords::getTaskId, (Object)task.getId())).eq(TaskRecords::getStatus, (Object)TaskRecords.FieldDict.STATUS_OK.getValue())).apply(INTERVAL_FLAG.equals((Object)ITask.IntervalFlag.D), "to_days(process_date) = to_days(now())", new Object[0])).apply(INTERVAL_FLAG.equals((Object)ITask.IntervalFlag.M), "date_format(process_date, '%Y%m') = date_format(curdate() , '%Y%m')", new Object[0]);
        TaskRecords currOKRecord = (TaskRecords)this.taskRecordsSvc.getOne((Wrapper)queryWrapper);
        boolean bl = isProcessOk = !Objects.isNull(currOKRecord);
        if (isProcessOk) {
            log.info("\u5f53\u524d\u4efb\u52a1 {} \u5df2\u7ecf\u4e8e{}\uff0c\u6267\u884c\u5230\u7b2c{}\u6b21\uff0c\u6210\u529f\u6267\u884c", new Object[]{task.getId(), currOKRecord.getProcessDate(), currOKRecord.getNumbOfExecutions()});
        }
        return isProcessOk;
    }

    private void _updateCurrRecords2Fail(TaskRecords currRecords) {
        currRecords.setStatus(TaskRecords.FieldDict.STATUS_FAIL.getValue());
        this.taskRecordsSvc.updateById(currRecords);
    }

    private void _updateCurrRecords2OK(TaskRecords currRecords) {
        currRecords.setStatus(TaskRecords.FieldDict.STATUS_OK.getValue());
        this.taskRecordsSvc.updateById(currRecords);
    }

    private TaskRecords _insertReportRecords(@NonNull ITask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        String taskId = task.getId();
        Integer lastTaskNumbOfExecution = this.taskRecordsMapper.getLastTaskNumbOfExecution(taskId, task.getIntervalFlag().name());
        int numbOfExecutions = 1;
        if (!Objects.isNull(lastTaskNumbOfExecution)) {
            numbOfExecutions += lastTaskNumbOfExecution.intValue();
        }
        TaskRecords currRecord = new TaskRecords().setTaskId(taskId).setStatus(TaskRecords.FieldDict.STATUS_PROCESSING.getValue()).setProcessDate(new Date()).setNodeIp(IPUtil.getLocalHostExactAddress().getHostAddress()).setNumbOfExecutions(numbOfExecutions);
        this.taskRecordsSvc.save(currRecord);
        return currRecord;
    }

    private void _updateCurrRecordsStatus(boolean processStatus, TaskRecords currRecords) {
        log.info("\u51c6\u5907\u66f4\u65b0\u4efb\u52a1\u8bb0\u5f55\u72b6\u6001 {} {}", (Object)processStatus, (Object)currRecords);
        if (processStatus) {
            this._updateCurrRecords2OK(currRecords);
        } else {
            this._updateCurrRecords2Fail(currRecords);
        }
    }

    public TaskTmpl(ITaskRecordsSvc taskRecordsSvc, TaskRecordsMapper taskRecordsMapper) {
        this.taskRecordsSvc = taskRecordsSvc;
        this.taskRecordsMapper = taskRecordsMapper;
    }
}

