package cn.jiiiiiin.task.ctl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import cn.jiiiiiin.task.service.ITaskRecordsSvc;
import cn.jiiiiiin.task.entity.TaskRecords;

@RestController
@RequestMapping("/taskRecords")
@AllArgsConstructor
@Slf4j
public class TaskRecordsCtl {

  private final ITaskRecordsSvc taskRecordsSvc;

  @GetMapping("/taskInfo")
  public List<TaskRecords> list() {
    final LambdaQueryWrapper<TaskRecords> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.orderByDesc(TaskRecords::getProcessDate);
    return taskRecordsSvc.list(queryWrapper);
  }


}
