/*
 * Decompiled with CFR 0.152.
 */
package cn.jianwoo.openai.auth;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.jianwoo.openai.auth.OpenAiAuth;
import cn.jianwoo.openai.auth.PostException;
import cn.jianwoo.openai.auth.SessionRes;
import com.alibaba.fastjson.JSONObject;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthPost {
    private static final Log log = LogFactory.get();
    public static final String ERROR_CODE = "999999";
    public static final String ERROR_MSG = "Authorization service error, code returns %s";
    private static Map<String, String> HEADER = new HashMap<String, String>();
    public static final String URL_1 = "https://explorer.api.openai.com/";
    public static final String URL_2 = "https://explorer.api.openai.com/api/auth/csrf";
    public static final String URL_3 = "https://explorer.api.openai.com/api/auth/signin/auth0?prompt=login";
    public static final String URL_4 = "";
    public static final String URL_5 = "https://auth0.openai.com/u/login/identifier?state=%s";
    public static final String URL_6 = "https://auth0.openai.com/u/login/identifier?state=%s";
    public static final String URL_7 = "https://auth0.openai.com/u/login/password?state=%s";
    public static final String URL_8 = "https://auth0.openai.com/u/login/password?state=%s";
    public static final String URL_9 = "https://auth0.openai.com/authorize/resume?state=%s";
    public static final String URL_10 = "https://explorer.api.openai.com/api/auth/callback/auth0?code=%s&state=%s";
    public static final String URL_11 = "https://explorer.api.openai.com/api/auth/session";
    public static final String ERR_MESSAGE1 = "Request Url (%s) failed with error code %s";
    public static final String ERR_MESSAGE2 = "Request Url (%s) failed with msg %s";
    private OpenAiAuth openAiAuth;
    private List<HttpCookie> cookies;

    private AuthPost() {
    }

    public AuthPost(OpenAiAuth openAiAuth) {
        this.openAiAuth = openAiAuth;
    }

    public SessionRes post() throws PostException {
        return this.post1();
    }

    private SessionRes post1() throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "explorer.api.openai.com");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)URL_1).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).execute();
        if (response.getStatus() != 200) {
            log.error(this.formatMsg1(URL_1, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        return this.post2();
    }

    private SessionRes post2() throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Referer", "https://explorer.api.openai.com/auth/login");
        headers.put("Accept", "*/*");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)URL_2).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200) {
            log.error(this.formatMsg1(URL_2, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        String csrfToken = null;
        try {
            String res = response.body();
            JSONObject json = JSONObject.parseObject((String)res);
            csrfToken = json.getString("csrfToken");
        }
        catch (Exception e) {
            log.error(this.formatMsg2(URL_2, response.body()), new Object[0]);
            throw new PostException("300001", "The csrfToken cannot be obtained.", new Object[0]);
        }
        this.cookies = response.getCookies();
        return this.post3(csrfToken);
    }

    private SessionRes post3(String csrfToken) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Referer", "https://explorer.api.openai.com/auth/login");
        headers.put("Origin", "https://explorer.api.openai.com");
        headers.put("Accept", "*/*");
        headers.put("Sec-Fetch-Site", "same-origin");
        headers.put("Sec-Fetch-Mode", "cors");
        headers.put("Sec-Fetch-Dest", "empty");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("callbackUrl", "/");
        payload.put("csrfToken", csrfToken);
        payload.put("json", true);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)URL_3).headerMap(headers, true)).form(payload).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200) {
            log.error(this.formatMsg1(URL_3, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        String url = null;
        try {
            String res = response.body();
            JSONObject json = JSONObject.parseObject((String)res);
            url = json.getString("url");
        }
        catch (Exception e) {
            log.error(this.formatMsg2(URL_3, response.body()), new Object[0]);
            throw new PostException(ERROR_CODE, "The URL cannot be obtained.", new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)url) || url.contains("error")) {
            throw new PostException("200001", "You have been rate limited.", new Object[0]);
        }
        this.cookies = response.getCookies();
        return this.post4(url);
    }

    private SessionRes post4(String url) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1(url, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            if (response.body().contains("rate limited")) {
                throw new PostException(ERROR_CODE, "You are being rate limited.", new Object[0]);
            }
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        if (!response.body().contains("state")) {
            log.error(this.formatMsg2(url, response.body()), new Object[0]);
            throw new PostException("300001", "The state cannot be obtained.", new Object[0]);
        }
        this.cookies = response.getCookies();
        String state = response.body().split("state")[1];
        state = state.split("\"")[0].substring(1);
        return this.post5(state);
    }

    private SessionRes post5(String state) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Referer", URL_1);
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)String.format("https://auth0.openai.com/u/login/identifier?state=%s", state)).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200) {
            log.error(this.formatMsg1("https://auth0.openai.com/u/login/identifier?state=%s", response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        return this.post6(state);
    }

    private SessionRes post6(String state) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Referer", String.format("https://auth0.openai.com/u/login/identifier?state=%s", state));
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Origin", "https://auth0.openai.com");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("state", state);
        payload.put("username", this.openAiAuth.getEmail());
        payload.put("js-available", false);
        payload.put("webauthn-available", true);
        payload.put("is-brave", false);
        payload.put("webauthn-platform-available", true);
        payload.put("action", "default");
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)String.format("https://auth0.openai.com/u/login/identifier?state=%s", state)).headerMap(headers, true)).form(payload).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1("https://auth0.openai.com/u/login/identifier?state=%s", response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        if (!response.body().contains("state")) {
            log.error(this.formatMsg2("https://auth0.openai.com/u/login/identifier?state=%s", response.body()), new Object[0]);
            throw new PostException("300001", "The state cannot be obtained.", new Object[0]);
        }
        this.cookies = response.getCookies();
        return this.post7(state);
    }

    private SessionRes post7(String state) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Referer", URL_1);
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)String.format("https://auth0.openai.com/u/login/password?state=%s", state)).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200) {
            log.error(this.formatMsg1("https://auth0.openai.com/u/login/password?state=%s", response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        return this.post8(state);
    }

    private SessionRes post8(String state) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Referer", String.format("https://auth0.openai.com/u/login/password?state=%s", state));
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Origin", "https://auth0.openai.com");
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("state", state);
        payload.put("username", this.openAiAuth.getEmail());
        payload.put("password", this.openAiAuth.getPassword());
        payload.put("action", "default");
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)String.format("https://auth0.openai.com/u/login/password?state=%s", state)).headerMap(headers, true)).form(payload).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() == 400) {
            if (response.body().contains("Wrong email or password")) {
                throw new PostException("400001", "Wrong email or password", new Object[0]);
            }
            if (response.body().contains("will be blocked")) {
                throw new PostException("400002", "We have detected suspicious login behavior and further attempts will be blocked. Please contact the administrator", new Object[0]);
            }
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1("https://auth0.openai.com/u/login/password?state=%s", response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        String newstate = response.body().split("state")[1];
        newstate = newstate.split("\"")[0].substring(1);
        return this.post9(state, newstate);
    }

    private SessionRes post9(String state, String newstate) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "auth0.openai.com");
        headers.put("Referer", String.format(URL_9, state));
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Origin", "https://auth0.openai.com");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)String.format(URL_9, newstate)).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1(URL_9, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        String url = response.body().split(" href=\"")[1];
        url = url.split("\"")[0];
        return this.post10(url);
    }

    private SessionRes post10(String url) throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Referer", url);
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).execute();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1(url, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        this.cookies = response.getCookies();
        return this.post11();
    }

    private SessionRes post11() throws PostException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(HEADER);
        headers.put("Host", "explorer.api.openai.com");
        headers.put("Referer", URL_11);
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)URL_11).headerMap(headers, true)).setProxy(this.openAiAuth.getProxy()).cookie(this.cookies).execute();
        if (response.getStatus() != 200 && response.getStatus() != 302) {
            log.error(this.formatMsg1(URL_11, response.getStatus()), new Object[0]);
            log.error(">>>>response:{}", new Object[]{response.body()});
            throw new PostException(ERROR_CODE, ERROR_MSG, response.getStatus());
        }
        SessionRes session = SessionRes.getInstance();
        try {
            String res = response.body();
            JSONObject json = JSONObject.parseObject((String)res);
            session.setAccessToken(json.getString("accessToken"));
            session.setExpires(json.getString("expires"));
            JSONObject user = json.getJSONObject("user");
            if (user != null) {
                session.setEmail(user.getString("email"));
                session.setId(user.getString("id"));
                session.setImage(user.getString("image"));
            }
            session.setSecureNextAuthSessionToken(response.getCookie("__Secure-next-auth.session-token").getValue());
        }
        catch (Exception e) {
            log.error(this.formatMsg2(URL_11, response.body()), new Object[0]);
            throw new PostException("300001", "The accessToken cannot be obtained.", new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)session.getAccessToken())) {
            throw new PostException("300001", "Fetch accessToken failed, maybe the interface on the website has changed.", new Object[0]);
        }
        return session;
    }

    private String formatMsg1(String url, int code) {
        return String.format(ERR_MESSAGE1, url, code);
    }

    private String formatMsg2(String url, String msg) {
        return String.format(ERR_MESSAGE2, url, msg);
    }

    static {
        HEADER.put("User-Agent", "Mozilla/5.0 (Macintosh; Arm Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36");
        HEADER.put("Accept-Language", "en-US,en;q=0.8");
        HEADER.put("Connection", "keep-alive");
        HEADER.put("Accept-Encoding", "gzip, deflate, br");
    }
}

