package cn.jiangzeyin;

import java.util.Random;

/**
 * Created by jiangzeyin on 2017/11/2.
 */
public class RandomUtil {
    private static final Random random = new Random();
    private static final String base = "ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678";

    /**
     * 生成随机字符串
     * <p>
     * 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
     *
     * @param length 长度
     * @return 结果
     */
    public static String getRandomString(int length) {

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /**
     * 随机生成指定长度的int 类型数字
     *
     * @param length 长度
     * @return 结果
     */
    public static int getRandomCode(int length) {
        int min = 1;
        int max = 9;
        int seep = 1;
        for (int i = 0; i < length - 1; i++) {
            min *= 10;
            seep *= 10;
            seep++;
        }
        if (seep != 1)
            max *= seep;
        return getRandom(min, max);
    }

    /**
     * 随机生成指定范围的随机数
     *
     * @param min 最小值
     * @param max 最大值
     * @return 结果
     */
    public static int getRandom(int min, int max) {
        if (max < min)
            throw new IllegalArgumentException("max < min");
        return random.nextInt(max) % (max - min + 1) + min;
    }
}
