package cn.jiangzeyin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * Created by jiangzeyin on 2017/11/29.
 */
public class DateUtil {
    /**
     * 格式化10位时间戳
     *
     * @param pattern    格式
     * @param timeMillis 10位时间戳
     * @return 结果
     * @author jiangzeyin
     */
    public static String formatTimeStamp(String pattern, int timeMillis) {
        if (pattern == null || pattern.length() == 0)
            pattern = "yyyy-MM-dd HH:mm:ss";
        Calendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis(timeMillis * 1000L);
        DateFormat df = new SimpleDateFormat(pattern);
        return df.format(nowDate.getTime());
    }

    /**
     * 格式化13位时间戳
     *
     * @param pattern    格式
     * @param timeMillis 13位时间戳
     * @return 结果
     * @author jiangzeyin
     */
    public static String formatTime(String pattern, long timeMillis) {
        if (pattern == null || pattern.length() == 0)
            pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(timeMillis);
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    /**
     * @return 当前10位时间戳
     */
    public static int getCurrentShortTimeMillis() {
        return (int) (getCurrentTimeMillis() / 1000L);
    }

    /**
     * 获取当前指定格式时间
     *
     * @param pattern 格式
     * @return 结果
     */
    public static String getCurrentFormatTime(String pattern) {
        return formatTime(pattern, getCurrentTimeMillis());
    }
}
