package cn.jiangzeyin.system;

import cn.jiangzeyin.entity.IQuartzInfo;
import cn.jiangzeyin.job.BaseJob;
import cn.jiangzeyin.job.JobUtil;
import cn.jiangzeyin.job.SystemJobListening;
import cn.jiangzeyin.log.JobLog;
import org.quartz.*;

import java.util.List;
import java.util.Properties;

/**
 * @author jiangzeyin
 * Created by jiangzeyin on 2017/2/13.
 */
public class SystemJobManager {

    private SystemJobManager() {
    }

    private static Properties properties;

    public static String getValue(String key) {
        return getValue(key, null);
    }

    public static String getValue(String key, String def) {
        if (properties == null)
            return null;
        return properties.getProperty(key, def);
    }

    public static class RunData {
        private static String keyName;
        private static String valueName;

        public static String getValueName() {
            return valueName;
        }

        public static String getKeyName() {
            return keyName;
        }
    }

    /**
     * 加载调度信息
     *
     * @param quartzInfoList list
     * @param properties     p
     * @throws SchedulerException     异常
     * @throws ClassNotFoundException 异常
     * @author jiangzeyin
     */
    public static void init(List<IQuartzInfo> quartzInfoList, Properties properties) throws ClassNotFoundException, SchedulerException {
        if (properties == null)
            throw new IllegalArgumentException("properties is null");
        if (SystemJobManager.properties != null) {
            throw new RuntimeException("job is Initialize");
        }
        SystemJobManager.properties = properties;
        //
        RunData.keyName = getValue(JobPropertiesInfo.RUN_DATA_KEY_NAME);
        if (RunData.keyName == null || RunData.keyName.isEmpty()) {
            JobLog.getInstance().warn("please se " + JobPropertiesInfo.RUN_DATA_KEY_NAME);
        }
        //
        RunData.valueName = getValue(JobPropertiesInfo.RUN_DATA_VALUE_NAME);
        if (RunData.valueName == null || RunData.valueName.isEmpty()) {
            JobLog.getInstance().warn("please se " + JobPropertiesInfo.RUN_DATA_VALUE_NAME);
        }
        if (quartzInfoList == null || quartzInfoList.size() <= 0) {
            JobLog.getInstance().info("调度信息为空");
        } else {
            for (IQuartzInfo quartz : quartzInfoList) {
                try {
                    JobUtil.addQuartz(quartz);
                } catch (Exception e) {
                    JobLog.getInstance().error("加载：" + quartz.getName() + "调度异常", e);
                }
            }
        }
        {// 对系统运行的一些检查
            JobLog.getInstance().info("初始化系统调度信息");
            Trigger trigger_def = JobUtil.getTrigger("system", "system_trigger_listening");
            if (trigger_def != null) {
                JobLog.getInstance().info("系统调度信息已经存在");
            } else {
                JobDetail job = JobBuilder.newJob(SystemJobListening.class)
                        .withIdentity("system_job_listening", "system")
                        .build();
                // 添加调度信息
                job.getJobDataMap().put("name", "系统监听调度");
                job.getJobDataMap().put("id", -1);
                job.getJobDataMap().put("type", BaseJob.Type.Guard);

                String cron = getValue(JobPropertiesInfo.SYSTEM_DETECTION_CRON, JobPropertiesInfo.SYSTEM_DETECTION_CRON_DEFAULT_VALUE);
                assert cron != null;
                CronTrigger trigger = TriggerBuilder.newTrigger()
                        .withIdentity("system_trigger_listening", "system")
                        .withSchedule(CronScheduleBuilder.cronSchedule(cron)).build();
                JobUtil.getScheduler().scheduleJob(job, trigger);
            }
        }
        // 开启调度
        JobUtil.getScheduler().start();
    }

}
