package cn.jiangzeyin.system;

import cn.jiangzeyin.entity.IQuartzInfo;
import com.alibaba.fastjson.JSONArray;

import java.util.List;

/**
 * Created by jiangzeyin on 2017/8/22.
 */
public class JobDataUtil implements JobDataInterface {
    private static JobDataInterface jobDataInterface;
    private static final JobDataUtil DATA_UTIL = new JobDataUtil();

    private JobDataUtil() {
    }

    public static void setDataInterface(JobDataInterface dataInterface) {
        JobDataUtil.jobDataInterface = dataInterface;
    }

    public static JobDataInterface getInstance() {
        return DATA_UTIL;
    }

    @Override
    public List<IQuartzInfo> getAll() {
        if (jobDataInterface == null)
            throw new RuntimeException("please set DataInterface");
        return jobDataInterface.getAll();
    }

    @Override
    public void update(Class<?> entityClass, int jobId, String data) {
        if (jobDataInterface == null)
            throw new RuntimeException("please set DataInterface");
        jobDataInterface.update(entityClass, jobId, data);
    }

    @Override
    public JSONArray getJobRunData(Class<?> entityClass, int jobId) {
        if (jobDataInterface == null)
            throw new RuntimeException("please set DataInterface");
        return jobDataInterface.getJobRunData(entityClass, jobId);
    }

    @Override
    public Class getJobDefaultClass() {
        if (jobDataInterface == null)
            throw new RuntimeException("please set DataInterface");
        return jobDataInterface.getJobDefaultClass();
    }
}
