package cn.jiangzeyin.entity;

import cn.jiangzeyin.system.SystemJobManager;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by jiangzeyin on 2017/8/22.
 */
public interface IQuartzInfo {
    int getId();

    String getName();

    String getGroupName();

    JSONArray getRunDataJson();

    String getRunData();

    String getRunClass();

    String getCron();

    /**
     * 当前调度运行状态
     *
     * @return 枚举值
     * @see Status
     */
    int getStatus();

    /**
     * 当前调度是否被删除
     *
     * @return 删除 true
     */
    boolean isDelete();

    /**
     * 当前调度是否是活跃状态
     *
     * @return 活跃 true
     */
    boolean isActive();

    /**
     * 请重写改方法，方便日志显示信息
     *
     * @return 实体信息
     */
    String toString();

    enum Status {
        Run(0, "正在运行"),
        Stop(1, "未运行"),
        Error(2, "运行异常");

        private int code;
        private String desc;

        Status(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    static JSONObject convertJSONObject(JSONArray jsonArray) {
        if (jsonArray == null)
            return null;
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            jsonObject.put(object.getString(SystemJobManager.RunData.getKeyName()), object.getString(SystemJobManager.RunData.getValueName()));
        }
        return jsonObject;
    }

}
