package cn.jiangzeyin.system;

import cn.jiangzeyin.entity.IQuartzInfo;
import com.alibaba.fastjson.JSONArray;

import java.util.List;

/**
 * Created by jiangzeyin on 2017/8/22.
 */
public class DataUtil implements DataInterface {
    private static DataInterface dataInterface;
    private static final DataUtil DATA_UTIL = new DataUtil();

    private DataUtil() {
    }

    public static void setDataInterface(DataInterface dataInterface) {
        DataUtil.dataInterface = dataInterface;
    }

    public static DataInterface getInstance() {
        return DATA_UTIL;
    }

    @Override
    public List<IQuartzInfo> getAll() {
        if (dataInterface == null)
            throw new RuntimeException("please set DataInterface");
        return dataInterface.getAll();
    }

    @Override
    public void update(Class<?> entityClass, int jobId, String data) {
        if (dataInterface == null)
            throw new RuntimeException("please set DataInterface");
        dataInterface.update(entityClass, jobId, data);
    }

    @Override
    public JSONArray getJobRunData(Class<?> entityClass, int jobId) {
        if (dataInterface == null)
            throw new RuntimeException("please set DataInterface");
        return dataInterface.getJobRunData(entityClass, jobId);
    }
}
