/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.j2cache;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.j2cache.J2CacheChannelProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.CacheChannel;

public class J2CacheMultiDatabase {
    private static Properties properties;
    private static final ConcurrentHashMap<Integer, CacheChannel> CACHE_CHANNEL_CONCURRENT_HASH_MAP;

    public static void initApplicationConfig(Properties properties) {
        J2CacheMultiDatabase.properties = properties;
    }

    public static void initApplicationConfig(String resurce) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = ResourceUtil.getStream((String)resurce);
        properties.load(inputStream);
        J2CacheMultiDatabase.initApplicationConfig(properties);
    }

    public static CacheChannel getChannel(int database) {
        Objects.requireNonNull(properties, "\u8bf7\u521d\u59cb\u5168\u5c40\u914d\u7f6e:initApplicationConfig");
        if (database < 0 || database > 255) {
            throw new IllegalArgumentException("0-255");
        }
        CacheChannel cacheChannel = CACHE_CHANNEL_CONCURRENT_HASH_MAP.computeIfAbsent(database, integer -> {
            Properties nowProperties = (Properties)properties.clone();
            nowProperties.setProperty("redis.database", integer.toString());
            String redisChannel = properties.getProperty("redis.channel");
            nowProperties.setProperty("redis.channel", redisChannel + "_" + integer);
            try {
                return J2CacheChannelProxy.getChannel(nowProperties);
            }
            catch (IOException e) {
                DefaultSystemLog.ERROR().error("channel \u5f02\u5e38", (Throwable)e);
                return null;
            }
        });
        Objects.requireNonNull(cacheChannel, "\u521d\u59cb\u5316\u5931\u8d25:" + database);
        return cacheChannel;
    }

    static {
        CACHE_CHANNEL_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    }
}

