/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.redis;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.cache.RedisCacheConfig;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.redis.RedisProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public final class RedisCacheManagerFactory {
    private static final ConcurrentHashMap<String, RedisCacheManager> REDIS_CACHE_MANAGER_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, RedisTemplate<String, Object>> REDIS_TEMPLATE_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    public static RedisCacheManager getRedisCacheManager(int database) {
        String key = "key_value_" + database;
        RedisCacheManager redisCacheManager = REDIS_CACHE_MANAGER_CONCURRENT_HASH_MAP.computeIfAbsent(key, s -> {
            RedisTemplate template = new RedisTemplate();
            RedisConnectionFactory connectionFactory = RedisConnectionFactoryPool.getRedisConnectionFactory(database);
            template.setConnectionFactory(connectionFactory);
            template.afterPropertiesSet();
            REDIS_TEMPLATE_CONCURRENT_HASH_MAP.put(key, (RedisTemplate<String, Object>)template);
            CustomizedRedisCacheManager redisCacheManager1 = new CustomizedRedisCacheManager(database, (RedisOperations)template);
            redisCacheManager1.setExpires(RedisCacheConfig.getExpires(database));
            redisCacheManager1.setDefaultExpiration(RedisCacheConfig.getDefaultExpireTime(database));
            redisCacheManager1.afterPropertiesSet();
            return redisCacheManager1;
        });
        Objects.requireNonNull(redisCacheManager, "init error");
        return redisCacheManager;
    }

    public static RedisTemplate<String, Object> getRedisTemplate(int database) {
        String key = "key_value_" + database;
        RedisTemplate<String, Object> template = REDIS_TEMPLATE_CONCURRENT_HASH_MAP.get(key);
        if (template == null) {
            RedisCacheManagerFactory.getRedisCacheManager(database);
            template = REDIS_TEMPLATE_CONCURRENT_HASH_MAP.get(key);
        }
        return template;
    }

    private static class RedisConnectionFactoryPool {
        private static volatile RedisProperties redisProperties;
        private static final ConcurrentHashMap<Integer, RedisConnectionFactory> REDIS_CONNECTION_FACTORY_CONCURRENT_HASH_MAP;

        private RedisConnectionFactoryPool() {
        }

        static RedisConnectionFactory getRedisConnectionFactory(int database) {
            String host;
            RedisConnectionFactory redisConnectionFactory = REDIS_CONNECTION_FACTORY_CONCURRENT_HASH_MAP.get(database);
            if (redisConnectionFactory != null) {
                return redisConnectionFactory;
            }
            if (redisProperties == null) {
                redisProperties = (RedisProperties)SpringUtil.getBean(RedisProperties.class);
            }
            if (StrUtil.isEmpty((CharSequence)(host = redisProperties.getHost()))) {
                throw new RuntimeException("\u8bf7\u914d\u7f6efast-bot.spring.redis \u5c5e\u6027");
            }
            redisConnectionFactory = new RedisConnectionConfiguration(redisProperties, database).redisConnectionFactory();
            REDIS_CONNECTION_FACTORY_CONCURRENT_HASH_MAP.put(database, redisConnectionFactory);
            return redisConnectionFactory;
        }

        static {
            REDIS_CONNECTION_FACTORY_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
        }

        private static class RedisConnectionConfiguration {
            private final RedisProperties properties;
            private final int database;

            private RedisConnectionConfiguration(RedisProperties redisProperties, int database) {
                this.properties = redisProperties;
                this.database = database;
            }

            JedisConnectionFactory redisConnectionFactory() {
                return this.applyProperties(this.createJedisConnectionFactory());
            }

            private JedisConnectionFactory applyProperties(JedisConnectionFactory factory) {
                factory.setHostName(this.properties.getHost());
                factory.setPort(this.properties.getPort());
                if (this.properties.getPassword() != null) {
                    factory.setPassword(this.properties.getPassword());
                }
                factory.setDatabase(this.database);
                if (this.properties.getTimeout() > 0) {
                    factory.setTimeout(this.properties.getTimeout());
                }
                factory.afterPropertiesSet();
                return factory;
            }

            private RedisSentinelConfiguration getSentinelConfig() {
                RedisProperties.Sentinel sentinelProperties = this.properties.getSentinel();
                if (sentinelProperties != null) {
                    RedisSentinelConfiguration config = new RedisSentinelConfiguration();
                    config.master(sentinelProperties.getMaster());
                    config.setSentinels(this.createSentinels(sentinelProperties));
                    return config;
                }
                return null;
            }

            private RedisClusterConfiguration getClusterConfiguration() {
                if (this.properties.getCluster() == null) {
                    return null;
                }
                RedisProperties.Cluster clusterProperties = this.properties.getCluster();
                RedisClusterConfiguration config = new RedisClusterConfiguration(clusterProperties.getNodes());
                if (clusterProperties.getMaxRedirects() != null) {
                    config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
                }
                return config;
            }

            private List<RedisNode> createSentinels(RedisProperties.Sentinel sentinel) {
                ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
                for (String node : StringUtils.commaDelimitedListToStringArray((String)sentinel.getNodes())) {
                    try {
                        String[] parts = StringUtils.split((String)node, (String)":");
                        Assert.state((parts.length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
                        nodes.add(new RedisNode(parts[0], Integer.parseInt(parts[1])));
                    }
                    catch (RuntimeException ex) {
                        throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
                    }
                }
                return nodes;
            }

            private JedisConnectionFactory createJedisConnectionFactory() {
                JedisPoolConfig poolConfig;
                JedisPoolConfig jedisPoolConfig = poolConfig = this.properties.getPool() != null ? this.jedisPoolConfig() : new JedisPoolConfig();
                if (this.getSentinelConfig() != null) {
                    return new JedisConnectionFactory(this.getSentinelConfig(), poolConfig);
                }
                if (this.getClusterConfiguration() != null) {
                    return new JedisConnectionFactory(this.getClusterConfiguration(), poolConfig);
                }
                return new JedisConnectionFactory(poolConfig);
            }

            private JedisPoolConfig jedisPoolConfig() {
                JedisPoolConfig config = new JedisPoolConfig();
                RedisProperties.Pool props = this.properties.getPool();
                config.setMaxTotal(props.getMaxActive());
                config.setMaxIdle(props.getMaxIdle());
                config.setMinIdle(props.getMinIdle());
                config.setMaxWaitMillis((long)props.getMaxWait());
                return config;
            }
        }
    }

    private static class CustomizedRedisCacheManager
    extends RedisCacheManager {
        private int database;

        CustomizedRedisCacheManager(int database, RedisOperations redisOperations) {
            super(redisOperations);
            this.database = database;
        }

        protected long computeExpiration(String name) {
            Long time = RedisCacheConfig.getGroupExpires(this.database, name);
            return time == null ? super.computeExpiration(name) : time.longValue();
        }
    }
}

