/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.config;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.annotation.FieldConfig;
import cn.jiangzeyin.sequence.ISequence;
import cn.jiangzeyin.util.DbReflectUtil;
import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class SystemColumn {
    private static String pwdColumn = "";
    private static final List<String> NOT_PUT_UPDATE = new ArrayList<String>();
    private static final HashMap<String, String> COLUMN_DEFAULT_VALUE = new HashMap();
    private static final List<String> WRITE_DEFAULT_REMOVE = new ArrayList<String>();
    private static final List<String> READ_DEFAULT_REMOVE = new ArrayList<String>();
    private static String defaultSelectColumns = "*";
    private static String defaultRefKeyName = "id";
    private static String defaultKeyName = "id";

    public static String getDefaultRefKeyName() {
        return defaultRefKeyName;
    }

    public static String getDefaultKeyName() {
        return defaultKeyName;
    }

    public static String getDefaultSelectColumns() {
        return defaultSelectColumns;
    }

    public static boolean isWriteRemove(String name) {
        return name != null && WRITE_DEFAULT_REMOVE.contains(name.toLowerCase());
    }

    public static boolean isReadRemove(String name) {
        return name != null && READ_DEFAULT_REMOVE.contains(name.toLowerCase());
    }

    public static String getDefaultValue(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return COLUMN_DEFAULT_VALUE.get(name.toLowerCase());
    }

    public static boolean isSequence(Class<?> cls, String name) {
        Field field = DbReflectUtil.getField(cls, name);
        if (field == null) {
            return false;
        }
        FieldConfig fieldConfig = field.getAnnotation(FieldConfig.class);
        if (fieldConfig == null) {
            return false;
        }
        Class<? extends ISequence> sequenceCls = fieldConfig.sequence();
        return sequenceCls != ISequence.class;
    }

    public static boolean notCanUpdate(String name) {
        return StringUtils.isEmpty((String)name) || NOT_PUT_UPDATE.contains(name.toLowerCase());
    }

    public static String getPwdColumn() {
        return pwdColumn;
    }

    static void init(Properties properties) {
        String keyDef;
        String refKeyDef;
        String columnsDef;
        String[] array;
        String readDef;
        String[] array2;
        String writeDef;
        String[] array3;
        String defaultValue;
        String[] array4;
        String notPutUpdate;
        String status;
        String tempPwdColumn = properties.getProperty("systemColumn.pwd");
        pwdColumn = StringUtil.convertNULL((String)tempPwdColumn);
        String column = properties.getProperty("systemColumn.active");
        Active.column = StringUtil.convertNULL((String)column);
        if (!StringUtils.isEmpty((String)Active.column)) {
            Active.activeValue = Integer.parseInt(properties.getProperty("systemColumn.active.value"));
            Active.inActiveValue = Integer.parseInt(properties.getProperty("systemColumn.inActive.value"));
        }
        if (Boolean.valueOf(status = properties.getProperty("systemColumn.modify.status")).booleanValue()) {
            Modify.status = true;
            String userColumn = properties.getProperty("systemColumn.modify.column");
            if (StringUtils.isEmpty((String)userColumn)) {
                throw new IllegalArgumentException("systemColumn.modify.column is null");
            }
            Modify.column = userColumn;
            String userTime = properties.getProperty("systemColumn.modify.time");
            if (StringUtils.isEmpty((String)userTime)) {
                throw new IllegalArgumentException("systemColumn.modify.time is null");
            }
            Modify.time = userTime;
        }
        if (!StringUtils.isEmpty((String)(notPutUpdate = properties.getProperty("systemColumn.notPutUpdate"))) && (array4 = StringUtil.stringToArray((String)notPutUpdate.toLowerCase())) != null) {
            NOT_PUT_UPDATE.addAll(Arrays.asList(array4));
        }
        if (!StringUtils.isEmpty((String)(defaultValue = properties.getProperty("systemColumn.columnDefaultValue"))) && (array3 = StringUtil.stringToArray((String)defaultValue, (String)",")) != null) {
            for (String item : array3) {
                String[] value = item.split(":");
                COLUMN_DEFAULT_VALUE.put(value[0].toLowerCase(), value[1]);
            }
        }
        if (!StringUtils.isEmpty((String)(writeDef = properties.getProperty("systemColumn.writeDefaultRemove"))) && (array2 = StringUtil.stringToArray((String)writeDef.toLowerCase())) != null) {
            WRITE_DEFAULT_REMOVE.addAll(Arrays.asList(array2));
        }
        if (!StringUtils.isEmpty((String)(readDef = properties.getProperty("systemColumn.readDefaultRemove"))) && (array = StringUtil.stringToArray((String)readDef.toLowerCase())) != null) {
            READ_DEFAULT_REMOVE.addAll(Arrays.asList(array));
        }
        if (!StringUtils.isEmpty((String)(columnsDef = properties.getProperty("systemColumn.selectDefaultColumns")))) {
            defaultSelectColumns = columnsDef;
        }
        if (!StringUtils.isEmpty((String)(refKeyDef = properties.getProperty("systemColumn.defaultRefKeyName")))) {
            defaultRefKeyName = refKeyDef;
        }
        if (!StringUtils.isEmpty((String)(keyDef = properties.getProperty("systemColumn.defaultKeyName")))) {
            defaultKeyName = keyDef;
        }
    }

    public static class Modify {
        private static boolean status = false;
        private static String column;
        private static String time;

        public static String getColumn() {
            return column;
        }

        public static String getTime() {
            return time;
        }

        public static boolean isStatus() {
            return status;
        }
    }

    public static class Active {
        public static final int NO_ACTIVE = -100;
        private static String column = "";
        private static int activeValue = -100;
        private static int inActiveValue;

        public static int getInActiveValue() {
            return inActiveValue;
        }

        public static String getColumn() {
            return column;
        }

        public static int getActiveValue() {
            return activeValue;
        }
    }
}

