/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database;

import cn.jiangzeyin.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;

public class Page<T> {
    private long pageNo;
    private long pageSize;
    private long totalRecord;
    private long totalPage;
    private List<T> results;
    private String whereWord;
    private String orderBy;
    private String sql;
    private List<Map<String, Object>> mapList;

    public List<Map<String, Object>> getMapList() {
        return this.mapList;
    }

    public Page setMapList(List<Map<String, Object>> mapList) {
        this.mapList = mapList;
        return this;
    }

    public Page() {
    }

    public Page(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public Page setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getWhereWord() {
        return this.whereWord;
    }

    public Page setWhereWord(String whereWord) {
        this.whereWord = StringUtil.isEmpty((String)this.whereWord) ? whereWord : this.whereWord + " and " + whereWord;
        return this;
    }

    public Page setPageNoAndSize(long pageNo, long pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Page setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public long getPageNo() {
        return this.pageNo;
    }

    public Page setPageNo(int pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public Page setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getTotalRecord() {
        return this.totalRecord;
    }

    public Page setTotalRecord(long totalRecord) {
        this.totalRecord = totalRecord;
        long totalPage = totalRecord % this.pageSize == 0L ? totalRecord / this.pageSize : totalRecord / this.pageSize + 1L;
        this.setTotalPage(totalPage);
        return this;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public Page setTotalPage(long totalPage) {
        this.totalPage = totalPage;
        return this;
    }

    public List<T> getResults() {
        return this.results;
    }

    public Page setResults(List<T> list) {
        this.results = list;
        return this;
    }

    public Page setResultsT(List<?> list) {
        this.results = list;
        return this;
    }

    public Page setDisplayPage(int start, int lenght) {
        int pageNo = 1;
        if (start >= lenght) {
            pageNo += start / lenght;
        }
        this.setPageNo(pageNo);
        this.setPageSize(lenght);
        return this;
    }

    public String toString() {
        return "Page [pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", results=" + this.results + ", totalPage=" + this.totalPage + ", totalRecord=" + this.totalRecord + "]";
    }

    public JSONObject toJSONObject(JSONArray jsonArray) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)this.getPageNo());
        data.put("pageSize", (Object)this.getPageSize());
        data.put("totalPage", (Object)this.getTotalPage());
        data.put("results", (Object)jsonArray);
        return data;
    }

    public JSONObject toJSONObject() {
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(this.getMapList()));
        return this.toJSONObject(jsonArray);
    }
}

