/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system;

import cn.jiangzeyin.system.DbLog;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DBExecutorService {
    private static final BlockingQueue<Runnable> BLOCKING_QUEUE = new LinkedBlockingQueue<Runnable>();
    private static final ProxyHeader PROXY_HEADER = new ProxyHeader();
    private static final SystemThreadFactory SYSTEM_THREAD_FACTORY = new SystemThreadFactory("dbutil");
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = DBExecutorService.newCachedThreadPool();

    private static ThreadPoolExecutor newCachedThreadPool() {
        return new ThreadPoolExecutor(50, Integer.MAX_VALUE, 5L, TimeUnit.MINUTES, BLOCKING_QUEUE, SYSTEM_THREAD_FACTORY, PROXY_HEADER);
    }

    public static JSONObject getPoolRunInfo() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)"dbutil");
        jsonObject.put("corePoolSize", (Object)THREAD_POOL_EXECUTOR.getCorePoolSize());
        jsonObject.put("poolSize", (Object)THREAD_POOL_EXECUTOR.getPoolSize());
        jsonObject.put("activeCount", (Object)THREAD_POOL_EXECUTOR.getActiveCount());
        jsonObject.put("largestPoolSize", (Object)THREAD_POOL_EXECUTOR.getLargestPoolSize());
        jsonObject.put("completedTaskCount", (Object)THREAD_POOL_EXECUTOR.getCompletedTaskCount());
        jsonObject.put("taskCount", (Object)THREAD_POOL_EXECUTOR.getTaskCount());
        jsonObject.put("queueSize", (Object)BLOCKING_QUEUE.size());
        jsonObject.put("rejectedExecutionCount", (Object)PROXY_HEADER.rejectedExecutionCount.get());
        jsonObject.put("maxThreadNumber", (Object)SYSTEM_THREAD_FACTORY.threadNumber.get());
        jsonObject.put("maximumPoolSize", (Object)THREAD_POOL_EXECUTOR.getMaximumPoolSize());
        return jsonObject;
    }

    public static void shutdown() {
        DbLog.getInstance().info("\u5173\u95ed\u6570\u636e\u5e93\u4f7f\u7528\u7684\u7ebf\u7a0b\u6c60");
        THREAD_POOL_EXECUTOR.shutdown();
    }

    public static void execute(Runnable command) {
        THREAD_POOL_EXECUTOR.execute(command);
    }

    private static class ProxyHeader
    extends ThreadPoolExecutor.CallerRunsPolicy {
        private final AtomicInteger rejectedExecutionCount = new AtomicInteger(0);

        private ProxyHeader() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            this.rejectedExecutionCount.getAndIncrement();
            super.rejectedExecution(r, e);
        }
    }

    private static class SystemThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        SystemThreadFactory(String poolName) {
            SecurityManager s;
            if (poolName == null || poolName.isEmpty()) {
                poolName = "pool";
            }
            this.group = (s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 10) {
                t.setPriority(10);
            }
            return t;
        }
    }
}

