/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.TransactionError;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public class Transaction {
    private Connection connection;
    private Callback callback;

    public Transaction(Class cls, Callback callback) {
        this(DbWriteService.getInstance().getDatabaseName(cls), callback);
    }

    public Transaction(String tag, Callback callback) {
        Objects.requireNonNull(callback);
        this.callback = callback;
        try {
            this.connection = DatabaseContextHolder.getWriteConnection(tag);
            if (this.connection == null) {
                throw new TransactionError("Transaction init getConnection error");
            }
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            callback.error(e);
            throw new TransactionError("Transaction init error:" + e.getMessage());
        }
        Operate operate = new Operate(this);
        try {
            callback.start(operate);
        }
        catch (Exception e) {
            this.rollback();
            callback.error(e);
            throw new TransactionError("Transaction error:" + e.getMessage());
        }
    }

    private void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("commit error", e);
            this.callback.error(e);
        }
        finally {
            JdbcUtils.close((Connection)this.connection);
        }
    }

    private void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("rollback error", e);
            this.callback.error(e);
        }
        finally {
            JdbcUtils.close((Connection)this.connection);
        }
    }

    public class Operate {
        private Transaction transaction;

        private Operate(Transaction transaction) {
            Objects.requireNonNull(transaction);
            this.transaction = transaction;
        }

        public Insert getInsert() {
            return new Insert(this.transaction.connection);
        }

        public Update getUpdate() {
            return new Update(this.transaction.connection);
        }

        public Remove getRemove() {
            return new Remove(this.transaction.connection);
        }

        public void commit() {
            this.transaction.commit();
        }

        public void rollback() {
            if (this.transaction != null) {
                this.transaction.rollback();
            }
        }
    }

    public static interface Callback {
        public void start(Operate var1);

        public void error(Exception var1);
    }
}

