/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.read;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.database.util.Util;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;

public class SelectPage<T>
extends ReadBase<T> {
    private Page<T> page;

    public SelectPage(Page<T> page) {
        this.page = page;
    }

    public SelectPage(Page<T> page, ReadBase.Result resultType) {
        this.page = page;
        this.setResultType(resultType);
    }

    public Page<T> getPage() {
        return this.page;
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run() {
        Objects.requireNonNull(this.page, "page");
        String errorSql = null;
        try {
            String tag = this.getTag();
            if (StringUtils.isEmpty((String)tag)) {
                tag = DbWriteService.getInstance().getDatabaseName(this.getTclass());
                this.setTag(tag);
            }
            String[] pageSql = StringUtils.isEmpty((String)this.page.getSql()) ? SqlUtil.getSelectPageSql(this) : SqlUtil.getSelectPageSql(this.page);
            DataSource dataSource = DatabaseContextHolder.getReadDataSource(tag);
            errorSql = pageSql[0];
            List list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[0], this.getParameters());
            if (list == null || list.size() < 1) {
                DbLog.getInstance().info(this.getTransferLog() + pageSql[1]);
                T t = null;
                return t;
            }
            Object count_map = (Map)list.get(0);
            if (count_map == null) {
                DbLog.getInstance().info(this.getTransferLog() + pageSql[1]);
                T t = null;
                return t;
            }
            long count = (Long)count_map.values().toArray()[0];
            this.page.setTotalRecord(count);
            this.setRunSql(pageSql[1]);
            DbLog.getInstance().info(this.getTransferLog() + pageSql[1]);
            errorSql = null;
            list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[1], this.getParameters());
            this.page.setMapList(list);
            if (this.getResultType() == ReadBase.Result.JsonArray) {
                count_map = JSON.toJSON((Object)list);
                return (T)count_map;
            }
            if (this.getResultType() == ReadBase.Result.PageResultType) {
                JSONObject data = new JSONObject();
                data.put("results", (Object)list);
                data.put("pageNo", (Object)this.page.getPageNo());
                data.put("pageSize", (Object)this.page.getPageSize());
                data.put("totalPage", (Object)this.page.getTotalPage());
                data.put("totalRecord", (Object)this.page.getTotalRecord());
                JSONObject jSONObject = data;
                return (T)jSONObject;
            }
            List result_list = Util.convertList(this, list);
            this.page.setResultsT(result_list);
            List list2 = result_list;
            return (T)list2;
        }
        catch (Exception e) {
            if (errorSql != null) {
                DbLog.getInstance().info(this.getTransferLog() + errorSql);
            }
            this.isThrows(e);
        }
        finally {
            this.runEnd();
            this.recycling();
        }
        return null;
    }
}

