/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database;

import cn.jiangzeyin.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;

public class Page<T> {
    private long pageNo;
    private long pageSize;
    private long totalRecord;
    private long totalPage;
    private List<T> results;
    private String whereWord;
    private String orderBy;
    private String sql;
    private List<Map<String, Object>> mapList;

    public List<Map<String, Object>> getMapList() {
        return this.mapList;
    }

    public void setMapList(List<Map<String, Object>> mapList) {
        this.mapList = mapList;
    }

    public Page() {
    }

    public Page(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getWhereWord() {
        return this.whereWord;
    }

    public void setWhereWord(String whereWord) {
        this.whereWord = StringUtil.isEmpty((String)this.whereWord) ? whereWord : this.whereWord + " and " + whereWord;
    }

    public void setPageNoAndSize(long pageNo, long pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public long getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalRecord() {
        return this.totalRecord;
    }

    public void setTotalRecord(long totalRecord) {
        this.totalRecord = totalRecord;
        long totalPage = totalRecord % this.pageSize == 0L ? totalRecord / this.pageSize : totalRecord / this.pageSize + 1L;
        this.setTotalPage(totalPage);
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> list) {
        this.results = list;
    }

    public void setResultsT(List<?> list) {
        this.results = list;
    }

    public void setDisplayPage(int start, int lenght) {
        int pageNo = 1;
        if (start >= lenght) {
            pageNo += start / lenght;
        }
        this.setPageNo(pageNo);
        this.setPageSize(lenght);
    }

    public String toString() {
        return "Page [pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", results=" + this.results + ", totalPage=" + this.totalPage + ", totalRecord=" + this.totalRecord + "]";
    }

    public JSONObject toJSONObject(JSONArray jsonArray) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)this.getPageNo());
        data.put("pageSize", (Object)this.getPageSize());
        data.put("totalPage", (Object)this.getTotalPage());
        data.put("results", (Object)jsonArray);
        return data;
    }

    public JSONObject toJSONObject() {
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(this.getMapList()));
        return this.toJSONObject(jsonArray);
    }
}

