/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.config;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.ModifyUser;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.system.SystemDbLog;
import cn.jiangzeyin.system.SystemKey;
import cn.jiangzeyin.util.Assert;
import cn.jiangzeyin.util.PropertiesParser;
import cn.jiangzeyin.util.ResourceUtil;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class DataSourceConfig {
    private static boolean active;
    private static PropertiesParser systemPropertiesParser;

    public static boolean isActive() {
        return active;
    }

    private DataSourceConfig() {
    }

    public static void init(String propertyPath) throws Exception {
        if (StringUtil.isEmpty((String)propertyPath)) {
            throw new IllegalArgumentException("propertyPath is null ");
        }
        InputStream inputStream = ResourceUtil.getResource(propertyPath);
        systemPropertiesParser = new PropertiesParser(inputStream);
        String active = systemPropertiesParser.getStringProperty("active", "dev");
        DataSourceConfig.active = "prod".equals(active);
        String[] sourceTags = systemPropertiesParser.getStringArrayProperty("sourceTag");
        Assert.notNull(sourceTags, "sourceTag is blank");
        if (sourceTags.length < 1) {
            throw new IllegalArgumentException("sourceTag is blank");
        }
        String[] configPaths = systemPropertiesParser.getStringArrayProperty("configPath");
        Assert.notNull(configPaths, "configPath is blank");
        if (configPaths.length < 1) {
            throw new IllegalArgumentException("configPath is blank");
        }
        DataSourceConfig.dataSource(sourceTags, configPaths);
        ModifyUser.initModify(systemPropertiesParser.getPropertyGroup("lastModify"));
        ModifyUser.initCreate(systemPropertiesParser.getPropertyGroup("create"));
        SystemColumn.init(systemPropertiesParser.getPropertyGroup("systemColumn"));
    }

    private static void dataSource(String[] sourceTags, String[] configPaths) throws Exception {
        SystemDbLog.getInstance().info("\u521d\u59cb\u5316\u8fde\u63a5\u6570\u636e\u5e93");
        if (configPaths.length == 1) {
            Map<String, DataSource> concurrentHashMap = DataSourceConfig.initConfigPath(sourceTags, configPaths[0]);
            DatabaseContextHolder.init(concurrentHashMap, configPaths[0]);
        } else {
            ArrayList<Map<String, DataSource>> mapList = new ArrayList<Map<String, DataSource>>();
            ArrayList<String> configList = new ArrayList<String>();
            for (String configPath : configPaths) {
                Map<String, DataSource> map = DataSourceConfig.initConfigPath(sourceTags, configPath);
                if (map == null || map.size() < 1) continue;
                mapList.add(map);
                configList.add(configPath);
            }
            DatabaseContextHolder.init(mapList.toArray(new Map[0]), configList.toArray(new String[0]));
        }
    }

    private static Map<String, DataSource> initConfigPath(String[] sourceTags, String configPath) throws Exception {
        String[] systemKeyColumn;
        SystemDbLog.getInstance().info("load " + configPath);
        PropertiesParser propertiesParser = new PropertiesParser(ResourceUtil.getResource(configPath));
        HashMap<String, DataSource> hashMap = new HashMap<String, DataSource>();
        String systemKey = systemPropertiesParser.getStringProperty("systemKey");
        SystemKey systemKey1 = null;
        if (systemKey != null) {
            systemKey1 = new SystemKey(systemKey);
        }
        if ((systemKeyColumn = systemPropertiesParser.getStringArrayProperty("systemKeyColumn", null)) != null && systemKey1 == null) {
            SystemDbLog.getInstance().warn(" use systemKeyColumn moust systemKey");
        }
        for (String tag : sourceTags) {
            int port;
            String ip;
            String[] ipInfo;
            boolean flag;
            Properties properties_tag = propertiesParser.getPropertyGroup(tag, true);
            if (properties_tag.isEmpty()) {
                SystemDbLog.getInstance().warn(tag + "is blank");
                continue;
            }
            String url = properties_tag.getProperty("url");
            if (systemKey1 != null && DataSourceConfig.arrayContainValue(systemKeyColumn, "url")) {
                url = systemKey1.decrypt(url);
            }
            if (!(flag = DataSourceConfig.isConnect((ipInfo = (ip = url.substring(url.indexOf("://") + 3, url.lastIndexOf("/"))).split(":"))[0], port = Integer.parseInt(ipInfo[1])))) {
                SystemDbLog.getInstance().warn(ip + "not Connect continue   " + tag);
                continue;
            }
            properties_tag.setProperty("url", url);
            String userName = properties_tag.getProperty("username");
            if (systemKey1 != null && DataSourceConfig.arrayContainValue(systemKeyColumn, "username")) {
                userName = systemKey1.decrypt(userName);
                properties_tag.setProperty("username", userName);
            }
            String pwd = properties_tag.getProperty("password");
            if (systemKey1 != null && DataSourceConfig.arrayContainValue(systemKeyColumn, "password")) {
                pwd = systemKey1.decrypt(pwd);
                properties_tag.setProperty("password", pwd);
            }
            DataSource dataSource = DruidDataSourceFactory.createDataSource((Properties)properties_tag);
            hashMap.put(tag, dataSource);
        }
        return hashMap;
    }

    private static boolean arrayContainValue(String[] array, String value) {
        if (array == null) {
            return false;
        }
        for (String item : array) {
            if (!value.equals(item)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isConnect(String host, int port) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

