/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer.impl;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import jexx.bean.BeanUtil;
import jexx.poi.SheetWriter;
import jexx.poi.cell.IMergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.meta.DVConstraintType;
import jexx.poi.row.RowContext;
import jexx.poi.style.CellStyleMapper;
import jexx.poi.util.DataValidationUtil;
import jexx.poi.writer.IndexRowWriter;
import jexx.poi.writer.MapRowWriter;
import jexx.poi.writer.impl.SheetRowWriterImpl;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.MapUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetWriterImpl
extends SheetRowWriterImpl
implements SheetWriter {
    private static final Logger log = LoggerFactory.getLogger(SheetWriterImpl.class);
    protected int currentRowNum = 0;
    private final MapRowWriter mapRowWriter = new MapRowWriter();
    private final IndexRowWriter indexRowWriter = new IndexRowWriter();

    public SheetWriterImpl(Sheet sheet) {
        super(sheet);
    }

    @Override
    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    @Override
    public void passCurrentRow() {
        this.skipRows(1);
    }

    @Override
    public void skipRows(int skipRowNum) {
        Assert.isTrue((skipRowNum > 0 ? 1 : 0) != 0, (String)"skipRowNum must be greater than zero!", (Object[])new Object[0]);
        this.currentRowNum += skipRowNum;
    }

    @Override
    public void jumpToRowNum(int rowNum) {
        Assert.isTrue((rowNum > 0 ? 1 : 0) != 0, (String)"rowNum must be greater than zero!", (Object[])new Object[0]);
        this.currentRowNum = rowNum;
    }

    @Override
    public void writeHeader(int rowNum, Headers headers, CellStyleMapper cellStyleMapper) {
        this.currentRowNum = this.doWriteRow(rowNum, headers, cellStyleMapper);
    }

    @Override
    public void writeHeader(int rowNum, Headers headers) {
        this.writeHeader(rowNum, headers, null);
    }

    @Override
    public void writeHeader(Headers headers, CellStyleMapper cellStyleMapper) {
        this.writeHeader(this.currentRowNum + 1, headers, cellStyleMapper);
    }

    @Override
    public void writeHeader(Headers headers) {
        this.writeHeader(headers, null);
    }

    @Override
    public int writeRows(int startRowNum, int columnNum, List<?> rows, CellStyleMapper cellStyleMapper) {
        if (CollectionUtil.isEmpty(rows)) {
            return -1;
        }
        RowContext rowContext = null;
        for (Object row : rows) {
            if (row instanceof List) {
                rowContext = this.doWriteRow(startRowNum, columnNum, (List)row, cellStyleMapper);
                continue;
            }
            if (row instanceof Map) {
                Map map = (Map)row;
                rowContext = this.doWriteRow(startRowNum, columnNum, MapUtil.convertValueToList((Map)map), cellStyleMapper);
                continue;
            }
            rowContext = this.doWriteRow(startRowNum, columnNum, CollectionUtil.list((Object[])new String[]{row.toString()}), cellStyleMapper);
        }
        return rowContext == null ? -1 : rowContext.getEndRowNum();
    }

    @Override
    public int writeRows(int startRowNum, int columnNum, List<?> rows) {
        return this.writeRows(startRowNum, columnNum, rows, null);
    }

    @Override
    public int writeRows(int columnNum, List<?> rows, CellStyleMapper cellStyleMapper) {
        return this.writeRows(this.currentRowNum + 1, columnNum, rows, cellStyleMapper);
    }

    @Override
    public int writeRows(int columnNum, List<?> rows) {
        return this.writeRows(columnNum, rows, (CellStyleMapper)null);
    }

    @Override
    public int writeRows(List<?> rows, CellStyleMapper cellStyleMapper) {
        return this.writeRows(1, rows, cellStyleMapper);
    }

    @Override
    public int writeRows(List<?> rows) {
        return this.writeRows(rows, (CellStyleMapper)null);
    }

    @Override
    public <T> int writeRows(int startRowNum, List<T> rows, Headers headers, BiConsumer<IMergedCell, T> consumer) {
        int endRowNum;
        if (CollectionUtil.isEmpty(rows)) {
            return -1;
        }
        RowContext rowContext = null;
        for (int i = 0; i < rows.size(); ++i) {
            T row = rows.get(i);
            int num = rowContext == null ? startRowNum : rowContext.getEndRowNum() + 1;
            rowContext = this.doWriteRow(num, row, headers, consumer, i);
        }
        int n = endRowNum = rowContext == null ? -1 : rowContext.getEndRowNum();
        if (this.supportValid && !headers.isIndex()) {
            this.doValidData(headers.getDataHeaders(), startRowNum, endRowNum);
        }
        return endRowNum;
    }

    @Override
    public <T> int writeRows(List<T> rows, Headers headers, BiConsumer<IMergedCell, T> consumer) {
        return this.writeRows(this.currentRowNum + 1, rows, headers, consumer);
    }

    @Override
    public int writeMapRows(int startRowNum, List<Map<String, Object>> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        if (CollectionUtil.isEmpty(rows)) {
            return -1;
        }
        RowContext rowContext = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map<String, Object> row = rows.get(i);
            int num = rowContext == null ? startRowNum : rowContext.getEndRowNum() + 1;
            rowContext = this.doWriteMapRow(num, row, headers, cellStyleMapper, i);
        }
        if (this.supportValid) {
            this.doValidData(headers.getDataHeaders(), startRowNum, startRowNum + rows.size() - 1);
        }
        return rowContext == null ? -1 : rowContext.getEndRowNum();
    }

    @Override
    public int writeMapRows(int startRowNum, List<Map<String, Object>> rows, Headers headers) {
        return this.writeMapRows(startRowNum, rows, headers, null);
    }

    @Override
    public int writeMapRows(List<Map<String, Object>> rows, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeMapRows(this.currentRowNum + 1, rows, headers, cellStyleMapper);
    }

    @Override
    public int writeMapRows(List<Map<String, Object>> rows, Headers headers) {
        return this.writeMapRows(rows, headers, null);
    }

    @Override
    public void fill(int fillStartRowNum, int fillEndRowNum, List<?> rows, Headers headers) {
        int fillLength = fillEndRowNum - fillStartRowNum + 1;
        Assert.isTrue((fillLength >= 0 ? 1 : 0) != 0);
        int rowsLength = rows.size();
        if (rowsLength > fillLength) {
            int specifyStyleRowNum = fillLength > 0 ? fillStartRowNum + 2 : fillStartRowNum;
            this.insertRows(specifyStyleRowNum, rowsLength - fillLength);
        }
        this.writeRows(fillStartRowNum, rows, headers);
    }

    @Override
    public RowContext writeRow(int startRowNum, Object rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        Assert.notNull((Object)headers);
        RowContext rowContext = this.doWriteRow(startRowNum, rowData, headers, cellStyleMapper, 0);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    @Override
    public RowContext writeRow(int startRowNum, Object rowData, Headers headers) {
        return this.writeRow(startRowNum, rowData, headers, null);
    }

    @Override
    public RowContext writeRow(Object rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeRow(this.currentRowNum + 1, rowData, headers, cellStyleMapper);
    }

    @Override
    public RowContext writeRow(Object rowData, Headers headers) {
        return this.writeRow(this.currentRowNum + 1, rowData, headers);
    }

    @Override
    public RowContext writeListRow(int startRowNum, int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = this.doWriteRow(startRowNum, columnNum, rowData, cellStyleMapper);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    @Override
    public RowContext writeListRow(int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        return this.writeListRow(this.currentRowNum + 1, columnNum, rowData, cellStyleMapper);
    }

    @Override
    public RowContext writeListRow(List<?> rowData, CellStyleMapper cellStyleMapper) {
        return this.writeListRow(1, rowData, cellStyleMapper);
    }

    @Override
    public RowContext writeListRow(List<?> rowData) {
        return this.writeListRow(1, rowData, null);
    }

    @Override
    public RowContext writeMapRow(int rowNum, Map<String, Object> map, Headers headers, CellStyleMapper cellStyleMapper) {
        Assert.notNull((Object)headers);
        return this.doWriteMapRow(rowNum, map, headers, cellStyleMapper, 0);
    }

    @Override
    public RowContext writeMapRow(int rowNum, Map<String, Object> map, Headers headers) {
        return this.writeMapRow(rowNum, map, headers, null);
    }

    @Override
    public RowContext writeMapRow(Map<String, Object> rowData, Headers headers, CellStyleMapper cellStyleMapper) {
        return this.writeMapRow(this.currentRowNum + 1, rowData, headers, cellStyleMapper);
    }

    @Override
    public RowContext writeMapRow(Map<String, Object> rowData, Headers headers) {
        return this.writeMapRow(rowData, headers, null);
    }

    protected RowContext doWriteRow(int rowNum, int columnNum, List<?> rowData, CellStyleMapper cellStyleMapper) {
        RowContext rowContext = RowContext.createRow(rowNum, columnNum, rowData, null);
        this.writeRow(rowContext, cellStyleMapper);
        return rowContext;
    }

    protected int doWriteRow(int rowNum, Headers headers, CellStyleMapper cellStyleMapper) {
        List<IMergedCell> cells = headers.createHeaderCells(rowNum);
        int maxEndRowNum = rowNum;
        for (IMergedCell cell : cells) {
            this.writeCell(cell, cellStyleMapper);
            maxEndRowNum = Math.max(cell.getLastRowNum(), maxEndRowNum);
        }
        return maxEndRowNum;
    }

    protected RowContext doWriteMapRow(int startRowNum, Map<String, Object> rowData, Headers headers, CellStyleMapper cellStyleMapper, int itemIndex) {
        return this.doWriteRow(startRowNum, rowData, headers, (IMergedCell cell, T bean) -> {
            if (cellStyleMapper != null) {
                cell.setCellStyle(cellStyleMapper.warpCellStyle((IMergedCell)cell));
            }
        }, itemIndex);
    }

    protected RowContext doWriteRow(int startRowNum, Object rowData, Headers headers, CellStyleMapper cellStyleMapper, int itemIndex) {
        return this.doWriteRow(startRowNum, rowData, headers, (IMergedCell cell, T bean) -> {
            if (cellStyleMapper != null) {
                cell.setCellStyle(cellStyleMapper.warpCellStyle((IMergedCell)cell));
            }
        }, itemIndex);
    }

    protected <T> RowContext doWriteRow(int startRowNum, T rowData, Headers headers, BiConsumer<IMergedCell, T> consumer, int itemIndex) {
        Assert.isTrue((rowData instanceof Map || BeanUtil.isBean(rowData.getClass()) ? 1 : 0) != 0, (String)"no support to write row[{}]", (Object[])new Object[]{rowData});
        RowContext rowContext = headers.isIndex() && !(rowData instanceof Map) ? this.indexRowWriter.writeRow(startRowNum, (Object)rowData, headers, itemIndex, !headers.isIndex()) : this.mapRowWriter.writeRow(startRowNum, BeanUtil.toMap(rowData), headers, itemIndex, !headers.isIndex());
        this.writeRow(rowContext, (Object)rowData, (BiConsumer)consumer);
        this.currentRowNum = rowContext.getEndRowNum();
        return rowContext;
    }

    @Override
    public void validData(int startRowNum, int rowCount, Headers headers) {
        Assert.isTrue((rowCount > 0 ? 1 : 0) != 0);
        List<IDataHeader> headerList = headers.getDataHeaders();
        this.doValidData(headerList, startRowNum, startRowNum + rowCount - 1);
    }

    @Override
    public void validData(int rowCount, Headers headers) {
        this.validData(this.currentRowNum + 1, rowCount, headers);
    }

    protected void doValidData(List<IDataHeader> headers, int startRowNum, int endRowNum) {
        if (endRowNum < startRowNum) {
            endRowNum = startRowNum;
        }
        if (CollectionUtil.isNotEmpty(headers)) {
            for (IDataHeader header : headers) {
                DVConstraintType dvConstraintType = header.getDVConstraintType();
                if (DVConstraintType.ARRAY != dvConstraintType && DVConstraintType.TREE != dvConstraintType) continue;
                int sr = startRowNum;
                if (this.sheet instanceof HSSFSheet) {
                    sr = 1;
                }
                String formula = header.createDataValidateFormula(sr);
                DataValidation dataValidation = DataValidationUtil.createValidation(this.sheet, formula, startRowNum, endRowNum, header.getStartColumnNum(), header.getEndColumnNum());
                this.sheet.addValidationData(dataValidation);
                log.debug("create data validation for header[{}], formula={}", (Object)header.getKey(), (Object)formula);
            }
        }
    }
}

