/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer.impl;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jexx.poi.cell.IMergedCell;
import jexx.poi.row.DataRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowContext;
import jexx.poi.style.CellStyleMapper;
import jexx.poi.writer.SheetRowWriter;
import jexx.poi.writer.impl.SheetCellWriterImpl;
import jexx.util.CollectionUtil;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetRowWriterImpl
extends SheetCellWriterImpl
implements SheetRowWriter {
    protected boolean repair = true;

    public SheetRowWriterImpl(Sheet sheet) {
        super(sheet);
    }

    @Override
    public SheetRowWriterImpl writeRow(RowContext row, CellStyleMapper cellStyleMapper) {
        return this.writeRow(row, (Object)null, (T cell, U bean) -> {
            if (cellStyleMapper != null) {
                cell.setCellStyle(cellStyleMapper.warpCellStyle((IMergedCell)cell));
            }
        });
    }

    @Override
    public SheetRowWriterImpl writeRow(RowContext row, Consumer<IMergedCell> consumer) {
        DataRow rootRow = row.getRootRow();
        if (this.repair) {
            row.repair();
        }
        this.doRecursionRow(rootRow, consumer);
        return this.writeRow(row, (Object)null, (T cell, U bean) -> {
            if (consumer != null) {
                consumer.accept((IMergedCell)cell);
            }
        });
    }

    @Override
    public <T> SheetRowWriterImpl writeRow(RowContext row, T bean, BiConsumer<IMergedCell, T> consumer) {
        DataRow rootRow = row.getRootRow();
        if (this.repair) {
            row.repair();
        }
        this.doRecursionRow(rootRow, bean, consumer);
        return this;
    }

    private void doRecursionRow(Row row, Consumer<IMergedCell> consumer) {
        List<IMergedCell> cells = row.getCells();
        for (IMergedCell cell : cells) {
            this.writeCell(cell, (Consumer)consumer);
        }
        List<Row> children = row.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (Row child : children) {
                this.doRecursionRow(child, consumer);
            }
        }
    }

    private <T> void doRecursionRow(Row row, T bean, BiConsumer<IMergedCell, T> consumer) {
        List<IMergedCell> cells = row.getCells();
        for (IMergedCell cell : cells) {
            this.writeCell(cell, bean, consumer);
        }
        List<Row> children = row.getChildren();
        if (CollectionUtil.isNotEmpty(children)) {
            for (Row child : children) {
                this.doRecursionRow(child, bean, consumer);
            }
        }
    }

    public void setRepair(boolean repair) {
        this.repair = repair;
    }
}

