/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.writer;

import jexx.poi.AbstractExcel;
import jexx.poi.meta.IMetaWriter;
import jexx.poi.meta.MetaSheetWriter;
import jexx.poi.meta.Metas;
import jexx.util.Assert;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcelWriter
extends AbstractExcel {
    protected int version;
    protected boolean hiddenMetaSheet;
    protected IMetaWriter metaWriter;

    public AbstractExcelWriter(Workbook workbook, boolean hiddenMetaSheet, int version) {
        Assert.isTrue((version >= 0 ? 1 : 0) != 0, (String)"version must be equal or greater than 0", (Object[])new Object[0]);
        this.workbook = workbook;
        this.hiddenMetaSheet = hiddenMetaSheet;
        this.version = version;
    }

    public void setHiddenMetaSheet(boolean hiddenMetaSheet) {
        this.hiddenMetaSheet = hiddenMetaSheet;
    }

    public void createMetaSheet(Metas metas) {
        Assert.isNull((Object)this.metaWriter, (String)"Can't repeatedly create meta sheet!", (Object[])new Object[0]);
        Sheet sheet = this.getOrCreateSheet("__METADATA__");
        if (this.hiddenMetaSheet) {
            this.workbook.setSheetVisibility(this.workbook.getSheetIndex(sheet), SheetVisibility.VERY_HIDDEN);
        }
        this.metaWriter = new MetaSheetWriter(sheet);
        this.metaWriter.save(metas);
        this.meta = metas;
    }
}

