/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import jexx.util.StringUtil;

public class NameUtil {
    public static final char REPLACE_CHAR = ' ';

    public static boolean validateName(String name) {
        boolean characterIsValid;
        char c = name.charAt(0);
        String allowedSymbols = "_\\";
        boolean bl = characterIsValid = Character.isLetter(c) || allowedSymbols.indexOf(c) != -1;
        if (!characterIsValid) {
            return false;
        }
        allowedSymbols = "_.?\\";
        for (char ch : name.toCharArray()) {
            boolean bl2 = characterIsValid = Character.isLetterOrDigit(ch) || allowedSymbols.indexOf(ch) != -1;
            if (characterIsValid) continue;
            return false;
        }
        return true;
    }

    public static String replaceIllegalCharForName(String name, boolean skipWhitespace) {
        String allowedSymbols = "_.?\\";
        char[] chars = name.toCharArray();
        boolean replace = false;
        for (int i = 0; i < chars.length; ++i) {
            boolean characterIsValid;
            char ch = chars[i];
            if (skipWhitespace && Character.isWhitespace(ch)) continue;
            boolean bl = characterIsValid = Character.isLetterOrDigit(ch) || allowedSymbols.indexOf(ch) != -1;
            if (characterIsValid) continue;
            chars[i] = 32;
            replace = true;
        }
        return replace ? new String(chars) : name;
    }

    public static String replaceIllegalCharForName(String name) {
        return NameUtil.replaceIllegalCharForName(name, true);
    }

    public static String encodeNameName(String str) {
        if (StringUtil.isEmpty((CharSequence)str)) {
            throw new IllegalArgumentException("excel name's name is not empty");
        }
        String name = String.valueOf('_').concat(str);
        return StringUtil.replace((CharSequence)name, (CharSequence)" ", (CharSequence)"");
    }
}

