/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.util;

import java.util.Calendar;
import java.util.Date;
import jexx.poi.cell.FormulaCellValue;
import jexx.time.DateUtil;
import jexx.util.Assert;
import jexx.util.CharUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;

public class CellOperateUtil {
    public static Cell getCell(Row row, int columnNum) {
        return CellUtil.getCell((Row)row, (int)(columnNum - 1));
    }

    public static Object getCellValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        return CellOperateUtil.getCellValue(cell, cell.getCellTypeEnum());
    }

    public static Object getCellValue(Cell cell, CellType cellType) {
        Object value;
        if (null == cell) {
            return null;
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = CellOperateUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CellOperateUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum());
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                value = null == error ? "" : error.getString();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return value;
    }

    private static Object getNumericValue(Cell cell) {
        long longPart;
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null == style) {
            return value;
        }
        short formatIndex = style.getDataFormat();
        if (CellOperateUtil.isDateType(cell, formatIndex)) {
            return DateUtil.date((Date)cell.getDateCellValue());
        }
        String format = style.getDataFormatString();
        if (null != format && !format.contains(".") && (double)(longPart = (long)value) == value) {
            return longPart;
        }
        return value;
    }

    public static int getLastCellNum(Row row) {
        short lastCellNum = row.getLastCellNum();
        if (lastCellNum == -1) {
            return -1;
        }
        return lastCellNum + 1;
    }

    public static String getStringCellValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        return cell.getStringCellValue();
    }

    private static boolean isDateType(Cell cell, int formatIndex) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell);
    }

    public static String toColumnLabel(int columnNum) {
        StringBuilder label = new StringBuilder();
        for (int columnIndex = columnNum - 1; columnIndex >= 0; --columnIndex) {
            label.append((char)(columnIndex % 26 + 65));
            columnIndex = (columnIndex - columnIndex % 26) / 26;
        }
        return label.reverse().toString();
    }

    public static int toColumnNum(String columnNo) {
        Assert.hasText((String)columnNo, (String)"label is not empty!", (Object[])new Object[0]);
        int result = 0;
        int length = columnNo.toUpperCase().length();
        for (int i = 0; i < length; ++i) {
            char ch = columnNo.charAt(length - i - 1);
            Assert.isTrue((boolean)CharUtil.isAlphaUpper((char)ch));
            int num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == value) {
            cell.setCellType(CellType.BLANK);
        } else if (value instanceof Date) {
            CellOperateUtil.setCellType(cell, CellType.NUMERIC);
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            CellOperateUtil.setCellType(cell, CellType.NUMERIC);
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            CellOperateUtil.setCellType(cell, CellType.BOOLEAN);
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            CellOperateUtil.setCellType(cell, CellType.STRING);
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            CellOperateUtil.setCellType(cell, CellType.NUMERIC);
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof FormulaCellValue) {
            CellOperateUtil.setCellType(cell, CellType.FORMULA);
            cell.setCellFormula(((FormulaCellValue)value).getFormula());
        } else {
            CellOperateUtil.setCellType(cell, CellType.STRING);
            cell.setCellValue(value.toString());
        }
    }

    private static void setCellType(Cell cell, CellType cellType) {
        if (cell instanceof XSSFCell) {
            cell.setCellType(cellType);
        }
    }

    public static void mergeCellsByUnsafe(Sheet sheet, int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRowNum - 1, lastRowNum - 1, firstColumnNum - 1, lastColumnNum - 1);
        sheet.addMergedRegionUnsafe(cellRangeAddress);
    }

    public static void mergeCells(Sheet sheet, int firstRowNum, int firstColumnNum, int lastRowNum, int lastColumnNum) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRowNum - 1, lastRowNum - 1, firstColumnNum - 1, lastColumnNum - 1);
        sheet.addMergedRegion(cellRangeAddress);
    }
}

