/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.style;

import jexx.util.StringUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleUtil {
    public static CellStyle createCellStyle(Workbook workbook) {
        return workbook.createCellStyle();
    }

    public static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        StyleUtil.wrapDefaultCellStyle(cellStyle);
        return cellStyle;
    }

    public static CellStyle wrapDefaultCellStyle(CellStyle cellStyle) {
        StyleUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        return cellStyle;
    }

    public static CellStyle createHeadCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        StyleUtil.warpHeadCellStyle(cellStyle);
        return cellStyle;
    }

    public static CellStyle warpHeadCellStyle(CellStyle cellStyle) {
        StyleUtil.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        StyleUtil.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        StyleUtil.setColor(cellStyle, IndexedColors.GREY_25_PERCENT, FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public static Font setFontStyle(Font font, short color, short fontSize, String fontName) {
        if (color > 0) {
            font.setColor(color);
        }
        if (fontSize > 0) {
            font.setFontHeightInPoints(fontSize);
        }
        if (StringUtil.isNotBlank((CharSequence)fontName)) {
            font.setFontName(fontName);
        }
        return font;
    }

    public static CellStyle setColor(CellStyle cellStyle, short color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern(fillPattern);
        return cellStyle;
    }

    public static CellStyle setColor(CellStyle cellStyle, IndexedColors color, FillPatternType fillPattern) {
        return StyleUtil.setColor(cellStyle, color.index, fillPattern);
    }

    public static CellStyle setBorder(CellStyle cellStyle, BorderStyle borderSize, IndexedColors colorIndex) {
        cellStyle.setBorderBottom(borderSize);
        cellStyle.setBottomBorderColor(colorIndex.index);
        cellStyle.setBorderLeft(borderSize);
        cellStyle.setLeftBorderColor(colorIndex.index);
        cellStyle.setBorderRight(borderSize);
        cellStyle.setRightBorderColor(colorIndex.index);
        cellStyle.setBorderTop(borderSize);
        cellStyle.setTopBorderColor(colorIndex.index);
        return cellStyle;
    }

    public static CellStyle setAlign(CellStyle cellStyle, HorizontalAlignment halign, VerticalAlignment valign) {
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        return cellStyle;
    }
}

