/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.row;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.cell.ICellSupportMeta;
import jexx.poi.cell.IMergedCell;
import jexx.poi.cell.MergedCell;
import jexx.poi.header.IDataHeader;
import jexx.poi.header.row.HeaderRow;
import jexx.poi.row.Row;
import jexx.poi.row.RowTypeEnum;
import jexx.poi.row.VirtualRow;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public class DataRow
extends Row {
    private String path = "";
    protected HeaderRow headerRow;
    private Map<Integer, IMergedCell> headerCellMap = new HashMap<Integer, IMergedCell>();

    @Override
    public RowTypeEnum getRowType() {
        return RowTypeEnum.DATA;
    }

    public DataRow() {
        this(-1);
    }

    public DataRow(int startRowNum) {
        this(startRowNum, startRowNum);
    }

    public DataRow(int startRowNum, int endRowNum) {
        Assert.isTrue((endRowNum >= startRowNum ? 1 : 0) != 0);
        this.startRowNum = startRowNum;
        this.endRowNum = endRowNum;
    }

    @Override
    protected void addCell(IMergedCell cell) {
        this.headerCellMap.put(cell.getFirstColumnNum(), cell);
        super.addCell(cell);
    }

    protected DataRow addDataRow(int rowCount) {
        Assert.isTrue((rowCount > 0 ? 1 : 0) != 0);
        DataRow row = new DataRow(this.endRowNum + 1, this.endRowNum + rowCount);
        return this.addDataRow(row, rowCount);
    }

    protected DataRow addDataRow() {
        return this.addDataRow(1);
    }

    protected DataRow addDataRow(DataRow row, int rowCount) {
        assert (row != null);
        if (CollectionUtil.isNotEmpty((Collection)this.children)) {
            Row last = (Row)this.children.get(this.children.size() - 1);
            last.setNextRow(row);
        }
        int startNum = this.findNextRowNumInChildren();
        int endNum = startNum + rowCount - 1;
        row.setStartRowNum(startNum);
        row.setEndRowNum(endNum);
        this.children.add(row);
        this.expandRow(this, endNum);
        return row;
    }

    protected VirtualRow appendVirtualRowAt(DataRow row) {
        return this.appendVirtualRowAt(row, 1);
    }

    protected VirtualRow appendVirtualRowAt(DataRow row, int rowCount) {
        assert (rowCount > 0);
        assert (this.hasRow(row));
        VirtualRow appendRow = new VirtualRow();
        appendRow.setStartRowNum(row.endRowNum + 1);
        int appendEndRow = row.endRowNum + rowCount;
        appendRow.setEndRowNum(appendEndRow);
        this.children.add(appendRow);
        this.expandRow(this, appendEndRow);
        Row nextRow = row.nextRow;
        row.nextRow = appendRow;
        if (nextRow != null) {
            appendRow.nextRow = nextRow;
            while (nextRow != null) {
                nextRow.raiseRowNum(rowCount);
                nextRow = nextRow.nextRow;
            }
        }
        return appendRow;
    }

    protected VirtualRow addVirtualRow(int rowCount) {
        assert (rowCount > 0);
        VirtualRow appendRow = new VirtualRow();
        if (CollectionUtil.isNotEmpty((Collection)this.children)) {
            Row last = (Row)this.children.get(this.children.size() - 1);
            last.setNextRow(appendRow);
        }
        int startNum = this.findNextRowNumInChildren();
        int endNum = startNum + rowCount - 1;
        appendRow.setStartRowNum(startNum);
        appendRow.setEndRowNum(endNum);
        this.children.add(appendRow);
        this.expandRow(this, endNum);
        return appendRow;
    }

    protected void repair() {
        if (this.headerRow != null) {
            HeaderRow child;
            Map<Integer, IDataHeader> headerMap = this.headerRow.getHeaderMap();
            if (headerMap != null) {
                headerMap.forEach((k, v) -> {
                    IMergedCell cell = this.getCellByColumnNum((int)k);
                    if (cell == null) {
                        MergedCell mergedCell = new MergedCell((Row)this, v.getStartColumnNum(), v.getEndColumnNum(), null, v.getDataCellStyle());
                        mergedCell.setMeta(v.getMeta());
                        mergedCell.valid(v.isValid());
                        IDataHeader referHeader = v.getReferHeader();
                        if (referHeader != null && this.parentRow != null) {
                            IMergedCell referCell = this.parentRow.getCellByColumnNum(referHeader.getStartColumnNum());
                            Assert.notNull((Object)referCell, (String)"Please check header[{}]", (Object[])new Object[]{referHeader.getKey()});
                            mergedCell.setCellReference((ICellSupportMeta)((Object)referCell));
                        }
                        this.addCell(mergedCell);
                    }
                });
            }
            if ((child = this.headerRow.getChild()) != null && CollectionUtil.isEmpty((Collection)this.children)) {
                DataRow row = this.addDataRow(1);
                row.setPath(child.getPath());
                row.setHeaderRow(child);
            }
        }
        if (this.children != null) {
            for (Row row : this.children) {
                if (!(row instanceof DataRow)) continue;
                ((DataRow)row).repair();
            }
        }
    }

    public IMergedCell getCellByColumnNum(int columnNum) {
        IMergedCell cell = this.headerCellMap.get(columnNum);
        if (cell != null) {
            return cell;
        }
        if (this.parentRow != null) {
            return this.parentRow.getCellByColumnNum(columnNum);
        }
        return null;
    }

    protected List<IMergedCell> getCellsByColumnNum(int columnNum) {
        ArrayList<IMergedCell> cells = new ArrayList<IMergedCell>();
        this.doRecursionRow(this, cells, columnNum);
        return cells;
    }

    private void doRecursionRow(DataRow row, List<IMergedCell> cells, int columnNum) {
        if (row != null) {
            if (row.headerCellMap.get(columnNum) != null) {
                cells.add(row.headerCellMap.get(columnNum));
            } else if (CollectionUtil.isNotEmpty((Collection)row.children)) {
                for (Row r : row.children) {
                    if (!(r instanceof DataRow)) continue;
                    this.doRecursionRow((DataRow)r, cells, columnNum);
                }
            }
        }
    }

    public boolean hasHeaderData(int columnNum) {
        return this.headerRow != null && this.headerRow.getHeaderMap().get(columnNum) != null;
    }

    public boolean hasHeaderDataInChild(int columnNum) {
        return this.headerRow != null && this.headerRow.getChild() != null && this.headerRow.getChild().getHeaderMap().get(columnNum) != null;
    }

    public Map<Integer, IMergedCell> getHeaderCellMap() {
        return this.headerCellMap;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHeaderRow(HeaderRow headerRow) {
        this.headerRow = headerRow;
    }
}

