/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.poi.RowMapper;
import jexx.poi.cell.IMergedCell;
import jexx.poi.header.Headers;
import jexx.poi.header.IDataHeader;
import jexx.poi.row.RowMap;
import jexx.util.MapUtil;
import jexx.util.StringUtil;

public class MapRowMapper
implements RowMapper<Map<String, Object>> {
    private final Headers headers;
    private final boolean supportTrimData;
    private final boolean skipEmptyRow;

    public MapRowMapper(Headers headers, boolean supportTrimData, boolean skipEmptyRow) {
        this.headers = headers;
        this.supportTrimData = supportTrimData;
        this.skipEmptyRow = skipEmptyRow;
    }

    @Override
    public Map<String, Object> mapRow(List<IMergedCell> cells, int rowNum) {
        RowMap labelMap = new RowMap();
        for (IMergedCell cell : cells) {
            IDataHeader header = this.headers.getDataHeaderByColumnNum(cell.getFirstColumnNum());
            if (header == null) continue;
            String key = header.getKey();
            Object value = cell.getValue();
            if (this.supportTrimData && value instanceof String) {
                value = StringUtil.trim((String)value.toString());
            }
            if (header.getUnwrapLabelFunction() != null) {
                value = header.getUnwrapLabelFunction().unwrap(value);
            }
            labelMap.putIfAbsent(key, value);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        for (IDataHeader dataHeader : this.headers.getDataHeaders()) {
            Object value = dataHeader.getValueByLabel(labelMap);
            if (value == null) continue;
            dataMap.put(dataHeader.getKey(), value);
        }
        if (this.skipEmptyRow && this.checkMapEmpty(dataMap)) {
            return null;
        }
        return dataMap;
    }

    private boolean checkMapEmpty(Map<String, Object> map) {
        if (map == null || MapUtil.isEmpty(map)) {
            return true;
        }
        for (Map.Entry<String, Object> m : map.entrySet()) {
            Object value = m.getValue();
            if (value == null || value instanceof String && StringUtil.isEmpty((CharSequence)((String)value))) continue;
            return false;
        }
        return true;
    }
}

