/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.read;

import java.util.Iterator;
import jexx.poi.exception.POIException;
import jexx.poi.read.DelegateRow;
import jexx.poi.util.CellOperateUtil;
import jexx.util.Assert;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class AbstractSheetReader {
    private final String sheetName;
    protected Iterator<Row> rowIterator;
    private DelegateRow nextRow;
    private DelegateRow currentRow;

    public AbstractSheetReader(Sheet sheet) {
        this.sheetName = sheet.getSheetName();
        this.rowIterator = sheet.iterator();
        this.doNextRow();
    }

    public String getName() {
        return this.sheetName;
    }

    protected Row getCurrentRow() {
        if (this.currentRow == null) {
            throw new POIException("no current row");
        }
        return this.currentRow;
    }

    protected int getCurrentRowNum() {
        return this.getCurrentRow().getRowNum() + 1;
    }

    protected boolean hasNextRow() {
        return this.rowIterator.hasNext();
    }

    protected Row doNextRow() {
        int cr;
        if (this.nextRow != null) {
            Assert.notNull((Object)this.currentRow, (String)"currentRow is null ?", (Object[])new Object[0]);
            Assert.isTrue((this.currentRow.getRowNum() < this.nextRow.getRowNum() ? 1 : 0) != 0, (String)"currentRow={},nextRow={} ", (Object[])new Object[]{this.currentRow.getRowNum(), this.nextRow.getRowNum()});
            if (this.currentRow.getRowNum() < this.nextRow.getRowNum() - 1) {
                this.currentRow = new DelegateRow(this.currentRow.getRowNum() + 1);
            } else {
                this.currentRow = this.nextRow;
                this.nextRow = null;
            }
            return this.currentRow;
        }
        if (!this.rowIterator.hasNext()) {
            throw new POIException("no next row");
        }
        DelegateRow delegateRow = new DelegateRow(this.rowIterator.next());
        int n = cr = this.currentRow == null ? -1 : this.currentRow.getRowNum();
        if (cr < delegateRow.getRowNum() - 1) {
            this.currentRow = new DelegateRow(cr + 1);
            this.nextRow = delegateRow;
        } else {
            this.currentRow = delegateRow;
        }
        return this.currentRow;
    }

    protected void doNextRowIfHasNext() {
        if (this.hasNextRow()) {
            this.doNextRow();
        } else {
            this.currentRow = null;
        }
    }

    protected Row doSkipRow(int skipRowNum) {
        Assert.isTrue((skipRowNum > 0 ? 1 : 0) != 0, (String)"skipRowNum is not illegal", (Object[])new Object[0]);
        Row thisRow = null;
        for (int rn = skipRowNum; rn > 0; --rn) {
            thisRow = this.doNextRow();
        }
        return thisRow;
    }

    protected Row doJumpToRow(int jumpRowNum) {
        Assert.isTrue((jumpRowNum > 0 ? 1 : 0) != 0, (String)"jumpRowNum is not illegal", (Object[])new Object[0]);
        Assert.isTrue((this.getCurrentRowNum() <= jumpRowNum ? 1 : 0) != 0, (String)"jumpRowNum is too small", (Object[])new Object[0]);
        if (jumpRowNum == this.getCurrentRowNum()) {
            return this.getCurrentRow();
        }
        while (this.getCurrentRowNum() >= jumpRowNum) {
            this.doNextRow();
        }
        return this.getCurrentRow();
    }

    protected Cell getCell(Row row, int columnNum) {
        return row.getCell(columnNum - 1);
    }

    protected Object getCellValue(Cell cell) {
        return CellOperateUtil.getCellValue(cell);
    }

    protected int getLastCellNumAtOneRow(Row row) {
        return row.getLastCellNum();
    }
}

