/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi.meta.node;

import java.util.List;
import java.util.Stack;
import jexx.poi.meta.node.INode;
import jexx.poi.util.NameUtil;
import jexx.util.Assert;
import jexx.util.ObjectUtil;

public class TreeNode
implements INode {
    public static final String ROOT_NODE_NAME = "RooT";
    private final Object value;
    private Object label;
    private TreeNode parent;
    private List<TreeNode> children;
    private boolean isRoot;
    private boolean isLeaf;

    public TreeNode(Object value) {
        this(value, value);
    }

    public TreeNode(Object value, Object label) {
        this(value, label, null, null);
    }

    public TreeNode(Object value, Object label, TreeNode parent, List<TreeNode> children) {
        Assert.notNull((Object)value);
        Assert.notNull((Object)label);
        this.value = value;
        this.label = label;
        this.parent = parent;
        this.children = children;
    }

    public static TreeNode createRootTreeNode() {
        return TreeNode.createRootTreeNode(ROOT_NODE_NAME);
    }

    public static TreeNode createRootTreeNode(String name) {
        TreeNode root = new TreeNode(name);
        root.isRoot = true;
        return root;
    }

    public String getFullValue() {
        Stack<String> stack = new Stack<String>();
        TreeNode p = this;
        while ((p = p.parent) != null) {
            Object l = p.getValue();
            stack.add(l == null ? "" : l.toString());
        }
        StringBuilder valueBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            String s = (String)stack.pop();
            valueBuilder.append(s).append("_");
        }
        valueBuilder.append(this.value);
        return valueBuilder.toString();
    }

    public String getFullLabel() {
        Stack<String> stack = new Stack<String>();
        TreeNode p = this;
        while ((p = p.parent) != null) {
            Object l = p.getLabel();
            stack.add(l == null ? "" : NameUtil.replaceIllegalCharForName(l.toString()));
        }
        StringBuilder valueBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            String s = (String)stack.pop();
            valueBuilder.append(s).append("_");
        }
        Object l = ObjectUtil.notNullOrDefault((Object)this.getLabel(), (Object)"");
        valueBuilder.append(l.toString());
        return valueBuilder.toString();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.isLeaf ? this.label : NameUtil.replaceIllegalCharForName(this.label.toString());
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        this.children = children;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public int hashCode() {
        int code = this.getFullValue().hashCode();
        code = 31 * code;
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof TreeNode) {
            TreeNode another = (TreeNode)o;
            return this.getFullLabel().equals(another.getFullValue());
        }
        return false;
    }
}

